/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.deploymentstacks.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.deploymentstacks.DeploymentStacksManager;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.DeploymentStacksClient;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.models.DeploymentStackInner;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.models.DeploymentStackTemplateDefinitionInner;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.models.DeploymentStackValidateResultInner;
import com.azure.resourcemanager.resources.deploymentstacks.implementation.DeploymentStackImpl;
import com.azure.resourcemanager.resources.deploymentstacks.implementation.DeploymentStackTemplateDefinitionImpl;
import com.azure.resourcemanager.resources.deploymentstacks.implementation.DeploymentStackValidateResultImpl;
import com.azure.resourcemanager.resources.deploymentstacks.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStack;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackTemplateDefinition;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackValidateResult;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStacks;
import com.azure.resourcemanager.resources.deploymentstacks.models.UnmanageActionManagementGroupMode;
import com.azure.resourcemanager.resources.deploymentstacks.models.UnmanageActionResourceGroupMode;
import com.azure.resourcemanager.resources.deploymentstacks.models.UnmanageActionResourceMode;

public final class DeploymentStacksImpl
implements DeploymentStacks {
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentStacksImpl.class);
    private final DeploymentStacksClient innerClient;
    private final DeploymentStacksManager serviceManager;

    public DeploymentStacksImpl(DeploymentStacksClient innerClient, DeploymentStacksManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DeploymentStack> listByResourceGroup(String resourceGroupName) {
        PagedIterable<DeploymentStackInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeploymentStackImpl((DeploymentStackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DeploymentStack> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<DeploymentStackInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeploymentStackImpl((DeploymentStackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DeploymentStack> list() {
        PagedIterable<DeploymentStackInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeploymentStackImpl((DeploymentStackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DeploymentStack> list(Context context) {
        PagedIterable<DeploymentStackInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeploymentStackImpl((DeploymentStackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DeploymentStack> listAtManagementGroup(String managementGroupId) {
        PagedIterable<DeploymentStackInner> inner = this.serviceClient().listAtManagementGroup(managementGroupId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeploymentStackImpl((DeploymentStackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DeploymentStack> listAtManagementGroup(String managementGroupId, Context context) {
        PagedIterable<DeploymentStackInner> inner = this.serviceClient().listAtManagementGroup(managementGroupId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeploymentStackImpl((DeploymentStackInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DeploymentStack> getByResourceGroupWithResponse(String resourceGroupName, String deploymentStackName, Context context) {
        Response<DeploymentStackInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, deploymentStackName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeploymentStackImpl((DeploymentStackInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DeploymentStack getByResourceGroup(String resourceGroupName, String deploymentStackName) {
        DeploymentStackInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, deploymentStackName);
        if (inner != null) {
            return new DeploymentStackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String deploymentStackName) {
        this.serviceClient().delete(resourceGroupName, deploymentStackName);
    }

    @Override
    public void delete(String resourceGroupName, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        this.serviceClient().delete(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
    }

    @Override
    public DeploymentStack createOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack) {
        DeploymentStackInner inner = this.serviceClient().createOrUpdateAtSubscription(deploymentStackName, deploymentStack);
        if (inner != null) {
            return new DeploymentStackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeploymentStack createOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        DeploymentStackInner inner = this.serviceClient().createOrUpdateAtSubscription(deploymentStackName, deploymentStack, context);
        if (inner != null) {
            return new DeploymentStackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DeploymentStack> getAtSubscriptionWithResponse(String deploymentStackName, Context context) {
        Response<DeploymentStackInner> inner = this.serviceClient().getAtSubscriptionWithResponse(deploymentStackName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeploymentStackImpl((DeploymentStackInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DeploymentStack getAtSubscription(String deploymentStackName) {
        DeploymentStackInner inner = this.serviceClient().getAtSubscription(deploymentStackName);
        if (inner != null) {
            return new DeploymentStackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteAtSubscription(String deploymentStackName) {
        this.serviceClient().deleteAtSubscription(deploymentStackName);
    }

    @Override
    public void deleteAtSubscription(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        this.serviceClient().deleteAtSubscription(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
    }

    @Override
    public DeploymentStack createOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        DeploymentStackInner inner = this.serviceClient().createOrUpdateAtManagementGroup(managementGroupId, deploymentStackName, deploymentStack);
        if (inner != null) {
            return new DeploymentStackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeploymentStack createOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        DeploymentStackInner inner = this.serviceClient().createOrUpdateAtManagementGroup(managementGroupId, deploymentStackName, deploymentStack, context);
        if (inner != null) {
            return new DeploymentStackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DeploymentStack> getAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, Context context) {
        Response<DeploymentStackInner> inner = this.serviceClient().getAtManagementGroupWithResponse(managementGroupId, deploymentStackName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeploymentStackImpl((DeploymentStackInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DeploymentStack getAtManagementGroup(String managementGroupId, String deploymentStackName) {
        DeploymentStackInner inner = this.serviceClient().getAtManagementGroup(managementGroupId, deploymentStackName);
        if (inner != null) {
            return new DeploymentStackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteAtManagementGroup(String managementGroupId, String deploymentStackName) {
        this.serviceClient().deleteAtManagementGroup(managementGroupId, deploymentStackName);
    }

    @Override
    public void deleteAtManagementGroup(String managementGroupId, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        this.serviceClient().deleteAtManagementGroup(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
    }

    @Override
    public Response<DeploymentStackTemplateDefinition> exportTemplateAtResourceGroupWithResponse(String resourceGroupName, String deploymentStackName, Context context) {
        Response<DeploymentStackTemplateDefinitionInner> inner = this.serviceClient().exportTemplateAtResourceGroupWithResponse(resourceGroupName, deploymentStackName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeploymentStackTemplateDefinitionImpl((DeploymentStackTemplateDefinitionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DeploymentStackTemplateDefinition exportTemplateAtResourceGroup(String resourceGroupName, String deploymentStackName) {
        DeploymentStackTemplateDefinitionInner inner = this.serviceClient().exportTemplateAtResourceGroup(resourceGroupName, deploymentStackName);
        if (inner != null) {
            return new DeploymentStackTemplateDefinitionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DeploymentStackTemplateDefinition> exportTemplateAtSubscriptionWithResponse(String deploymentStackName, Context context) {
        Response<DeploymentStackTemplateDefinitionInner> inner = this.serviceClient().exportTemplateAtSubscriptionWithResponse(deploymentStackName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeploymentStackTemplateDefinitionImpl((DeploymentStackTemplateDefinitionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DeploymentStackTemplateDefinition exportTemplateAtSubscription(String deploymentStackName) {
        DeploymentStackTemplateDefinitionInner inner = this.serviceClient().exportTemplateAtSubscription(deploymentStackName);
        if (inner != null) {
            return new DeploymentStackTemplateDefinitionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DeploymentStackTemplateDefinition> exportTemplateAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, Context context) {
        Response<DeploymentStackTemplateDefinitionInner> inner = this.serviceClient().exportTemplateAtManagementGroupWithResponse(managementGroupId, deploymentStackName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeploymentStackTemplateDefinitionImpl((DeploymentStackTemplateDefinitionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DeploymentStackTemplateDefinition exportTemplateAtManagementGroup(String managementGroupId, String deploymentStackName) {
        DeploymentStackTemplateDefinitionInner inner = this.serviceClient().exportTemplateAtManagementGroup(managementGroupId, deploymentStackName);
        if (inner != null) {
            return new DeploymentStackTemplateDefinitionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeploymentStackValidateResult validateStackAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        DeploymentStackValidateResultInner inner = this.serviceClient().validateStackAtResourceGroup(resourceGroupName, deploymentStackName, deploymentStack);
        if (inner != null) {
            return new DeploymentStackValidateResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeploymentStackValidateResult validateStackAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        DeploymentStackValidateResultInner inner = this.serviceClient().validateStackAtResourceGroup(resourceGroupName, deploymentStackName, deploymentStack, context);
        if (inner != null) {
            return new DeploymentStackValidateResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeploymentStackValidateResult validateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack) {
        DeploymentStackValidateResultInner inner = this.serviceClient().validateStackAtSubscription(deploymentStackName, deploymentStack);
        if (inner != null) {
            return new DeploymentStackValidateResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeploymentStackValidateResult validateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        DeploymentStackValidateResultInner inner = this.serviceClient().validateStackAtSubscription(deploymentStackName, deploymentStack, context);
        if (inner != null) {
            return new DeploymentStackValidateResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeploymentStackValidateResult validateStackAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        DeploymentStackValidateResultInner inner = this.serviceClient().validateStackAtManagementGroup(managementGroupId, deploymentStackName, deploymentStack);
        if (inner != null) {
            return new DeploymentStackValidateResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeploymentStackValidateResult validateStackAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        DeploymentStackValidateResultInner inner = this.serviceClient().validateStackAtManagementGroup(managementGroupId, deploymentStackName, deploymentStack, context);
        if (inner != null) {
            return new DeploymentStackValidateResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DeploymentStack getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String deploymentStackName = ResourceManagerUtils.getValueFromIdByName(id, "deploymentStacks");
        if (deploymentStackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deploymentStacks'.", id)));
        }
        return (DeploymentStack)this.getByResourceGroupWithResponse(resourceGroupName, deploymentStackName, Context.NONE).getValue();
    }

    @Override
    public Response<DeploymentStack> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String deploymentStackName = ResourceManagerUtils.getValueFromIdByName(id, "deploymentStacks");
        if (deploymentStackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deploymentStacks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, deploymentStackName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String deploymentStackName = ResourceManagerUtils.getValueFromIdByName(id, "deploymentStacks");
        if (deploymentStackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deploymentStacks'.", id)));
        }
        UnmanageActionResourceMode localUnmanageActionResources = null;
        UnmanageActionResourceGroupMode localUnmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode localUnmanageActionManagementGroups = null;
        Boolean localBypassStackOutOfSyncError = null;
        this.delete(resourceGroupName, deploymentStackName, localUnmanageActionResources, localUnmanageActionResourceGroups, localUnmanageActionManagementGroups, localBypassStackOutOfSyncError, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String deploymentStackName = ResourceManagerUtils.getValueFromIdByName(id, "deploymentStacks");
        if (deploymentStackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deploymentStacks'.", id)));
        }
        this.delete(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
    }

    private DeploymentStacksClient serviceClient() {
        return this.innerClient;
    }

    private DeploymentStacksManager manager() {
        return this.serviceManager;
    }

    @Override
    public DeploymentStackImpl define(String name) {
        return new DeploymentStackImpl(name, this.manager());
    }
}

