/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupRequestBase;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupSettings;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupStoreDetails;
import java.io.IOException;

public final class BackupsLongTermRetentionRequest
extends BackupRequestBase {
    private BackupStoreDetails targetDetails;
    private static final ClientLogger LOGGER = new ClientLogger(BackupsLongTermRetentionRequest.class);

    public BackupStoreDetails targetDetails() {
        return this.targetDetails;
    }

    public BackupsLongTermRetentionRequest withTargetDetails(BackupStoreDetails targetDetails) {
        this.targetDetails = targetDetails;
        return this;
    }

    @Override
    public BackupsLongTermRetentionRequest withBackupSettings(BackupSettings backupSettings) {
        super.withBackupSettings(backupSettings);
        return this;
    }

    @Override
    public void validate() {
        if (this.targetDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetDetails in model BackupsLongTermRetentionRequest"));
        }
        this.targetDetails().validate();
        if (this.backupSettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupSettings in model BackupsLongTermRetentionRequest"));
        }
        this.backupSettings().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backupSettings", (JsonSerializable)this.backupSettings());
        jsonWriter.writeJsonField("targetDetails", (JsonSerializable)this.targetDetails);
        return jsonWriter.writeEndObject();
    }

    public static BackupsLongTermRetentionRequest fromJson(JsonReader jsonReader) throws IOException {
        return (BackupsLongTermRetentionRequest)jsonReader.readObject(reader -> {
            BackupsLongTermRetentionRequest deserializedBackupsLongTermRetentionRequest = new BackupsLongTermRetentionRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupSettings".equals(fieldName)) {
                    deserializedBackupsLongTermRetentionRequest.withBackupSettings(BackupSettings.fromJson(reader));
                    continue;
                }
                if ("targetDetails".equals(fieldName)) {
                    deserializedBackupsLongTermRetentionRequest.targetDetails = BackupStoreDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupsLongTermRetentionRequest;
        });
    }
}

