/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.GeographicallyRedundantBackup;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class Backup
implements JsonSerializable<Backup> {
    private Integer backupRetentionDays;
    private GeographicallyRedundantBackup geoRedundantBackup;
    private OffsetDateTime earliestRestoreDate;

    public Integer backupRetentionDays() {
        return this.backupRetentionDays;
    }

    public Backup withBackupRetentionDays(Integer backupRetentionDays) {
        this.backupRetentionDays = backupRetentionDays;
        return this;
    }

    public GeographicallyRedundantBackup geoRedundantBackup() {
        return this.geoRedundantBackup;
    }

    public Backup withGeoRedundantBackup(GeographicallyRedundantBackup geoRedundantBackup) {
        this.geoRedundantBackup = geoRedundantBackup;
        return this;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("backupRetentionDays", (Number)this.backupRetentionDays);
        jsonWriter.writeStringField("geoRedundantBackup", this.geoRedundantBackup == null ? null : this.geoRedundantBackup.toString());
        return jsonWriter.writeEndObject();
    }

    public static Backup fromJson(JsonReader jsonReader) throws IOException {
        return (Backup)jsonReader.readObject(reader -> {
            Backup deserializedBackup = new Backup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupRetentionDays".equals(fieldName)) {
                    deserializedBackup.backupRetentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("geoRedundantBackup".equals(fieldName)) {
                    deserializedBackup.geoRedundantBackup = GeographicallyRedundantBackup.fromString(reader.getString());
                    continue;
                }
                if ("earliestRestoreDate".equals(fieldName)) {
                    deserializedBackup.earliestRestoreDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackup;
        });
    }
}

