/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualEndpointResourceProperties;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointResourceForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointType;
import java.io.IOException;
import java.util.List;

public final class VirtualEndpointInner
extends VirtualEndpointResourceForPatch {
    private String id;
    private String name;
    private String type;
    private SystemData systemData;
    private VirtualEndpointResourceProperties innerProperties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    private VirtualEndpointResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public VirtualEndpointType endpointType() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointType();
    }

    @Override
    public VirtualEndpointInner withEndpointType(VirtualEndpointType endpointType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualEndpointResourceProperties();
        }
        this.innerProperties().withEndpointType(endpointType);
        return this;
    }

    @Override
    public List<String> members() {
        return this.innerProperties() == null ? null : this.innerProperties().members();
    }

    @Override
    public VirtualEndpointInner withMembers(List<String> members) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualEndpointResourceProperties();
        }
        this.innerProperties().withMembers(members);
        return this;
    }

    @Override
    public List<String> virtualEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualEndpoints();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties());
        return jsonWriter.writeEndObject();
    }

    public static VirtualEndpointInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualEndpointInner)jsonReader.readObject(reader -> {
            VirtualEndpointInner deserializedVirtualEndpointInner = new VirtualEndpointInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedVirtualEndpointInner.innerProperties = VirtualEndpointResourceProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVirtualEndpointInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualEndpointInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualEndpointInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVirtualEndpointInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualEndpointInner;
        });
    }
}

