/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Cancel;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceServer;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrateRolesAndPermissions;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParametersForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDatabasesOnTargetServer;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigration;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutover;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class MigrationPropertiesForPatch
implements JsonSerializable<MigrationPropertiesForPatch> {
    private String sourceDbServerResourceId;
    private String sourceDbServerFullyQualifiedDomainName;
    private String targetDbServerFullyQualifiedDomainName;
    private MigrationSecretParametersForPatch secretParameters;
    private List<String> dbsToMigrate;
    private LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded;
    private OverwriteDatabasesOnTargetServer overwriteDbsInTarget;
    private OffsetDateTime migrationWindowStartTimeInUtc;
    private MigrateRolesAndPermissions migrateRoles;
    private StartDataMigration startDataMigration;
    private TriggerCutover triggerCutover;
    private List<String> dbsToTriggerCutoverOn;
    private Cancel cancel;
    private List<String> dbsToCancelMigrationOn;
    private MigrationMode migrationMode;

    public String sourceDbServerResourceId() {
        return this.sourceDbServerResourceId;
    }

    public MigrationPropertiesForPatch withSourceDbServerResourceId(String sourceDbServerResourceId) {
        this.sourceDbServerResourceId = sourceDbServerResourceId;
        return this;
    }

    public String sourceDbServerFullyQualifiedDomainName() {
        return this.sourceDbServerFullyQualifiedDomainName;
    }

    public MigrationPropertiesForPatch withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName) {
        this.sourceDbServerFullyQualifiedDomainName = sourceDbServerFullyQualifiedDomainName;
        return this;
    }

    public String targetDbServerFullyQualifiedDomainName() {
        return this.targetDbServerFullyQualifiedDomainName;
    }

    public MigrationPropertiesForPatch withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName) {
        this.targetDbServerFullyQualifiedDomainName = targetDbServerFullyQualifiedDomainName;
        return this;
    }

    public MigrationSecretParametersForPatch secretParameters() {
        return this.secretParameters;
    }

    public MigrationPropertiesForPatch withSecretParameters(MigrationSecretParametersForPatch secretParameters) {
        this.secretParameters = secretParameters;
        return this;
    }

    public List<String> dbsToMigrate() {
        return this.dbsToMigrate;
    }

    public MigrationPropertiesForPatch withDbsToMigrate(List<String> dbsToMigrate) {
        this.dbsToMigrate = dbsToMigrate;
        return this;
    }

    public LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded() {
        return this.setupLogicalReplicationOnSourceDbIfNeeded;
    }

    public MigrationPropertiesForPatch withSetupLogicalReplicationOnSourceDbIfNeeded(LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded) {
        this.setupLogicalReplicationOnSourceDbIfNeeded = setupLogicalReplicationOnSourceDbIfNeeded;
        return this;
    }

    public OverwriteDatabasesOnTargetServer overwriteDbsInTarget() {
        return this.overwriteDbsInTarget;
    }

    public MigrationPropertiesForPatch withOverwriteDbsInTarget(OverwriteDatabasesOnTargetServer overwriteDbsInTarget) {
        this.overwriteDbsInTarget = overwriteDbsInTarget;
        return this;
    }

    public OffsetDateTime migrationWindowStartTimeInUtc() {
        return this.migrationWindowStartTimeInUtc;
    }

    public MigrationPropertiesForPatch withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc) {
        this.migrationWindowStartTimeInUtc = migrationWindowStartTimeInUtc;
        return this;
    }

    public MigrateRolesAndPermissions migrateRoles() {
        return this.migrateRoles;
    }

    public MigrationPropertiesForPatch withMigrateRoles(MigrateRolesAndPermissions migrateRoles) {
        this.migrateRoles = migrateRoles;
        return this;
    }

    public StartDataMigration startDataMigration() {
        return this.startDataMigration;
    }

    public MigrationPropertiesForPatch withStartDataMigration(StartDataMigration startDataMigration) {
        this.startDataMigration = startDataMigration;
        return this;
    }

    public TriggerCutover triggerCutover() {
        return this.triggerCutover;
    }

    public MigrationPropertiesForPatch withTriggerCutover(TriggerCutover triggerCutover) {
        this.triggerCutover = triggerCutover;
        return this;
    }

    public List<String> dbsToTriggerCutoverOn() {
        return this.dbsToTriggerCutoverOn;
    }

    public MigrationPropertiesForPatch withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn) {
        this.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn;
        return this;
    }

    public Cancel cancel() {
        return this.cancel;
    }

    public MigrationPropertiesForPatch withCancel(Cancel cancel) {
        this.cancel = cancel;
        return this;
    }

    public List<String> dbsToCancelMigrationOn() {
        return this.dbsToCancelMigrationOn;
    }

    public MigrationPropertiesForPatch withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn) {
        this.dbsToCancelMigrationOn = dbsToCancelMigrationOn;
        return this;
    }

    public MigrationMode migrationMode() {
        return this.migrationMode;
    }

    public MigrationPropertiesForPatch withMigrationMode(MigrationMode migrationMode) {
        this.migrationMode = migrationMode;
        return this;
    }

    public void validate() {
        if (this.secretParameters() != null) {
            this.secretParameters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceDbServerResourceId", this.sourceDbServerResourceId);
        jsonWriter.writeStringField("sourceDbServerFullyQualifiedDomainName", this.sourceDbServerFullyQualifiedDomainName);
        jsonWriter.writeStringField("targetDbServerFullyQualifiedDomainName", this.targetDbServerFullyQualifiedDomainName);
        jsonWriter.writeJsonField("secretParameters", (JsonSerializable)this.secretParameters);
        jsonWriter.writeArrayField("dbsToMigrate", this.dbsToMigrate, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("setupLogicalReplicationOnSourceDbIfNeeded", this.setupLogicalReplicationOnSourceDbIfNeeded == null ? null : this.setupLogicalReplicationOnSourceDbIfNeeded.toString());
        jsonWriter.writeStringField("overwriteDbsInTarget", this.overwriteDbsInTarget == null ? null : this.overwriteDbsInTarget.toString());
        jsonWriter.writeStringField("migrationWindowStartTimeInUtc", this.migrationWindowStartTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.migrationWindowStartTimeInUtc));
        jsonWriter.writeStringField("migrateRoles", this.migrateRoles == null ? null : this.migrateRoles.toString());
        jsonWriter.writeStringField("startDataMigration", this.startDataMigration == null ? null : this.startDataMigration.toString());
        jsonWriter.writeStringField("triggerCutover", this.triggerCutover == null ? null : this.triggerCutover.toString());
        jsonWriter.writeArrayField("dbsToTriggerCutoverOn", this.dbsToTriggerCutoverOn, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("cancel", this.cancel == null ? null : this.cancel.toString());
        jsonWriter.writeArrayField("dbsToCancelMigrationOn", this.dbsToCancelMigrationOn, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("migrationMode", this.migrationMode == null ? null : this.migrationMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static MigrationPropertiesForPatch fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationPropertiesForPatch)jsonReader.readObject(reader -> {
            MigrationPropertiesForPatch deserializedMigrationPropertiesForPatch = new MigrationPropertiesForPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceDbServerResourceId".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.sourceDbServerResourceId = reader.getString();
                    continue;
                }
                if ("sourceDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.sourceDbServerFullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("targetDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.targetDbServerFullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("secretParameters".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.secretParameters = MigrationSecretParametersForPatch.fromJson(reader);
                    continue;
                }
                if ("dbsToMigrate".equals(fieldName)) {
                    List dbsToMigrate;
                    deserializedMigrationPropertiesForPatch.dbsToMigrate = dbsToMigrate = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("setupLogicalReplicationOnSourceDbIfNeeded".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.setupLogicalReplicationOnSourceDbIfNeeded = LogicalReplicationOnSourceServer.fromString(reader.getString());
                    continue;
                }
                if ("overwriteDbsInTarget".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.overwriteDbsInTarget = OverwriteDatabasesOnTargetServer.fromString(reader.getString());
                    continue;
                }
                if ("migrationWindowStartTimeInUtc".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.migrationWindowStartTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("migrateRoles".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.migrateRoles = MigrateRolesAndPermissions.fromString(reader.getString());
                    continue;
                }
                if ("startDataMigration".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.startDataMigration = StartDataMigration.fromString(reader.getString());
                    continue;
                }
                if ("triggerCutover".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.triggerCutover = TriggerCutover.fromString(reader.getString());
                    continue;
                }
                if ("dbsToTriggerCutoverOn".equals(fieldName)) {
                    List dbsToTriggerCutoverOn;
                    deserializedMigrationPropertiesForPatch.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("cancel".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.cancel = Cancel.fromString(reader.getString());
                    continue;
                }
                if ("dbsToCancelMigrationOn".equals(fieldName)) {
                    List dbsToCancelMigrationOn;
                    deserializedMigrationPropertiesForPatch.dbsToCancelMigrationOn = dbsToCancelMigrationOn = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("migrationMode".equals(fieldName)) {
                    deserializedMigrationPropertiesForPatch.migrationMode = MigrationMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationPropertiesForPatch;
        });
    }
}

