/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class CapturedLogProperties
implements JsonSerializable<CapturedLogProperties> {
    private OffsetDateTime createdTime;
    private OffsetDateTime lastModifiedTime;
    private Long sizeInKb;
    private String type;
    private String url;

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public CapturedLogProperties withCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public CapturedLogProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public Long sizeInKb() {
        return this.sizeInKb;
    }

    public CapturedLogProperties withSizeInKb(Long sizeInKb) {
        this.sizeInKb = sizeInKb;
        return this;
    }

    public String type() {
        return this.type;
    }

    public CapturedLogProperties withType(String type) {
        this.type = type;
        return this;
    }

    public String url() {
        return this.url;
    }

    public CapturedLogProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdTime", this.createdTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeNumberField("sizeInKb", (Number)this.sizeInKb);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    public static CapturedLogProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CapturedLogProperties)jsonReader.readObject(reader -> {
            CapturedLogProperties deserializedCapturedLogProperties = new CapturedLogProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdTime".equals(fieldName)) {
                    deserializedCapturedLogProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedCapturedLogProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sizeInKb".equals(fieldName)) {
                    deserializedCapturedLogProperties.sizeInKb = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCapturedLogProperties.type = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedCapturedLogProperties.url = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapturedLogProperties;
        });
    }
}

