/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AzureManagedDiskPerformanceTiers;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StorageAutoGrow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StorageType;
import java.io.IOException;

public final class Storage
implements JsonSerializable<Storage> {
    private Integer storageSizeGB;
    private StorageAutoGrow autoGrow;
    private AzureManagedDiskPerformanceTiers tier;
    private Integer iops;
    private Integer throughput;
    private StorageType type;

    public Integer storageSizeGB() {
        return this.storageSizeGB;
    }

    public Storage withStorageSizeGB(Integer storageSizeGB) {
        this.storageSizeGB = storageSizeGB;
        return this;
    }

    public StorageAutoGrow autoGrow() {
        return this.autoGrow;
    }

    public Storage withAutoGrow(StorageAutoGrow autoGrow) {
        this.autoGrow = autoGrow;
        return this;
    }

    public AzureManagedDiskPerformanceTiers tier() {
        return this.tier;
    }

    public Storage withTier(AzureManagedDiskPerformanceTiers tier) {
        this.tier = tier;
        return this;
    }

    public Integer iops() {
        return this.iops;
    }

    public Storage withIops(Integer iops) {
        this.iops = iops;
        return this;
    }

    public Integer throughput() {
        return this.throughput;
    }

    public Storage withThroughput(Integer throughput) {
        this.throughput = throughput;
        return this;
    }

    public StorageType type() {
        return this.type;
    }

    public Storage withType(StorageType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("storageSizeGB", (Number)this.storageSizeGB);
        jsonWriter.writeStringField("autoGrow", this.autoGrow == null ? null : this.autoGrow.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        jsonWriter.writeNumberField("iops", (Number)this.iops);
        jsonWriter.writeNumberField("throughput", (Number)this.throughput);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static Storage fromJson(JsonReader jsonReader) throws IOException {
        return (Storage)jsonReader.readObject(reader -> {
            Storage deserializedStorage = new Storage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageSizeGB".equals(fieldName)) {
                    deserializedStorage.storageSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("autoGrow".equals(fieldName)) {
                    deserializedStorage.autoGrow = StorageAutoGrow.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedStorage.tier = AzureManagedDiskPerformanceTiers.fromString(reader.getString());
                    continue;
                }
                if ("iops".equals(fieldName)) {
                    deserializedStorage.iops = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("throughput".equals(fieldName)) {
                    deserializedStorage.throughput = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorage.type = StorageType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorage;
        });
    }
}

