/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AdminCredentials;
import java.io.IOException;

public final class MigrationSecretParameters
implements JsonSerializable<MigrationSecretParameters> {
    private AdminCredentials adminCredentials;
    private String sourceServerUsername;
    private String targetServerUsername;
    private static final ClientLogger LOGGER = new ClientLogger(MigrationSecretParameters.class);

    public AdminCredentials adminCredentials() {
        return this.adminCredentials;
    }

    public MigrationSecretParameters withAdminCredentials(AdminCredentials adminCredentials) {
        this.adminCredentials = adminCredentials;
        return this;
    }

    public String sourceServerUsername() {
        return this.sourceServerUsername;
    }

    public MigrationSecretParameters withSourceServerUsername(String sourceServerUsername) {
        this.sourceServerUsername = sourceServerUsername;
        return this;
    }

    public String targetServerUsername() {
        return this.targetServerUsername;
    }

    public MigrationSecretParameters withTargetServerUsername(String targetServerUsername) {
        this.targetServerUsername = targetServerUsername;
        return this;
    }

    public void validate() {
        if (this.adminCredentials() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property adminCredentials in model MigrationSecretParameters"));
        }
        this.adminCredentials().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("adminCredentials", (JsonSerializable)this.adminCredentials);
        jsonWriter.writeStringField("sourceServerUsername", this.sourceServerUsername);
        jsonWriter.writeStringField("targetServerUsername", this.targetServerUsername);
        return jsonWriter.writeEndObject();
    }

    public static MigrationSecretParameters fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationSecretParameters)jsonReader.readObject(reader -> {
            MigrationSecretParameters deserializedMigrationSecretParameters = new MigrationSecretParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("adminCredentials".equals(fieldName)) {
                    deserializedMigrationSecretParameters.adminCredentials = AdminCredentials.fromJson(reader);
                    continue;
                }
                if ("sourceServerUsername".equals(fieldName)) {
                    deserializedMigrationSecretParameters.sourceServerUsername = reader.getString();
                    continue;
                }
                if ("targetServerUsername".equals(fieldName)) {
                    deserializedMigrationSecretParameters.targetServerUsername = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationSecretParameters;
        });
    }
}

