/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.FlexibleServersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.LtrBackupResponseInner;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.LtrPreBackupResponseInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FlexibleServersTriggerLtrPreBackupResponse;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LtrBackupRequest;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LtrPreBackupRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FlexibleServersClientImpl
implements FlexibleServersClient {
    private final FlexibleServersService service;
    private final PostgreSqlManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(FlexibleServersClientImpl.class);

    FlexibleServersClientImpl(PostgreSqlManagementClientImpl client) {
        this.service = (FlexibleServersService)RestProxy.create(FlexibleServersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FlexibleServersTriggerLtrPreBackupResponse> triggerLtrPreBackupWithResponseAsync(String resourceGroupName, String serverName, LtrPreBackupRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.triggerLtrPreBackup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LtrPreBackupResponseInner> triggerLtrPreBackupAsync(String resourceGroupName, String serverName, LtrPreBackupRequest parameters) {
        return this.triggerLtrPreBackupWithResponseAsync(resourceGroupName, serverName, parameters).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FlexibleServersTriggerLtrPreBackupResponse triggerLtrPreBackupWithResponse(String resourceGroupName, String serverName, LtrPreBackupRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.triggerLtrPreBackupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LtrPreBackupResponseInner triggerLtrPreBackup(String resourceGroupName, String serverName, LtrPreBackupRequest parameters) {
        return this.triggerLtrPreBackupWithResponse(resourceGroupName, serverName, parameters, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startLtrBackupWithResponseAsync(String resourceGroupName, String serverName, LtrBackupRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startLtrBackup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> startLtrBackupWithResponse(String resourceGroupName, String serverName, LtrBackupRequest parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.startLtrBackupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> startLtrBackupWithResponse(String resourceGroupName, String serverName, LtrBackupRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.startLtrBackupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<LtrBackupResponseInner>, LtrBackupResponseInner> beginStartLtrBackupAsync(String resourceGroupName, String serverName, LtrBackupRequest parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startLtrBackupWithResponseAsync(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)LtrBackupResponseInner.class), (Type)((Object)LtrBackupResponseInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<LtrBackupResponseInner>, LtrBackupResponseInner> beginStartLtrBackup(String resourceGroupName, String serverName, LtrBackupRequest parameters) {
        Response<BinaryData> response = this.startLtrBackupWithResponse(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(response, (Type)((Object)LtrBackupResponseInner.class), (Type)((Object)LtrBackupResponseInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<LtrBackupResponseInner>, LtrBackupResponseInner> beginStartLtrBackup(String resourceGroupName, String serverName, LtrBackupRequest parameters, Context context) {
        Response<BinaryData> response = this.startLtrBackupWithResponse(resourceGroupName, serverName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)LtrBackupResponseInner.class), (Type)((Object)LtrBackupResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LtrBackupResponseInner> startLtrBackupAsync(String resourceGroupName, String serverName, LtrBackupRequest parameters) {
        return this.beginStartLtrBackupAsync(resourceGroupName, serverName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LtrBackupResponseInner startLtrBackup(String resourceGroupName, String serverName, LtrBackupRequest parameters) {
        return (LtrBackupResponseInner)this.beginStartLtrBackup(resourceGroupName, serverName, parameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LtrBackupResponseInner startLtrBackup(String resourceGroupName, String serverName, LtrBackupRequest parameters, Context context) {
        return (LtrBackupResponseInner)this.beginStartLtrBackup(resourceGroupName, serverName, parameters, context).getFinalResult();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PostgreSqlManagement")
    public static interface FlexibleServersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/ltrPreBackup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<FlexibleServersTriggerLtrPreBackupResponse> triggerLtrPreBackup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") LtrPreBackupRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/ltrPreBackup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public FlexibleServersTriggerLtrPreBackupResponse triggerLtrPreBackupSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") LtrPreBackupRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/startLtrBackup")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> startLtrBackup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") LtrBackupRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/startLtrBackup")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> startLtrBackupSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") LtrBackupRequest var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

