/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.DatabaseInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Database;

public final class DatabaseImpl
implements Database,
Database.Definition {
    private DatabaseInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private String databaseName;

    DatabaseImpl(DatabaseInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String charset() {
        return this.innerModel().charset();
    }

    @Override
    public String collation() {
        return this.innerModel().collation();
    }

    @Override
    public DatabaseInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public Database create() {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().create(this.resourceGroupName, this.serverName, this.databaseName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Database create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().create(this.resourceGroupName, this.serverName, this.databaseName, this.innerModel(), context);
        return this;
    }

    DatabaseImpl(String name, PostgreSqlManager serviceManager) {
        this.innerObject = new DatabaseInner();
        this.serviceManager = serviceManager;
        this.databaseName = name;
    }

    @Override
    public Database refresh() {
        this.innerObject = (DatabaseInner)((Object)this.serviceManager.serviceClient().getDatabases().getWithResponse(this.resourceGroupName, this.serverName, this.databaseName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Database refresh(Context context) {
        this.innerObject = (DatabaseInner)((Object)this.serviceManager.serviceClient().getDatabases().getWithResponse(this.resourceGroupName, this.serverName, this.databaseName, context).getValue());
        return this;
    }

    @Override
    public DatabaseImpl withCharset(String charset) {
        this.innerModel().withCharset(charset);
        return this;
    }

    @Override
    public DatabaseImpl withCollation(String collation) {
        this.innerModel().withCollation(collation);
        return this;
    }
}

