/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwright.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.playwright.fluent.models.PlaywrightWorkspaceInner;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspaceProperties;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspaceUpdateProperties;
import java.util.Map;

public interface PlaywrightWorkspace {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public PlaywrightWorkspaceProperties properties();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public PlaywrightWorkspaceInner innerModel();

    public Update update();

    public PlaywrightWorkspace refresh();

    public PlaywrightWorkspace refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(PlaywrightWorkspaceUpdateProperties var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithProperties {
        public PlaywrightWorkspace apply();

        public PlaywrightWorkspace apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithProperties {
            public WithCreate withProperties(PlaywrightWorkspaceProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties {
            public PlaywrightWorkspace create();

            public PlaywrightWorkspace create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

