/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwright.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.playwright.PlaywrightManager;
import com.azure.resourcemanager.playwright.fluent.PlaywrightQuotasClient;
import com.azure.resourcemanager.playwright.fluent.models.PlaywrightQuotaInner;
import com.azure.resourcemanager.playwright.implementation.PlaywrightQuotaImpl;
import com.azure.resourcemanager.playwright.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.playwright.models.PlaywrightQuota;
import com.azure.resourcemanager.playwright.models.PlaywrightQuotas;
import com.azure.resourcemanager.playwright.models.QuotaName;

public final class PlaywrightQuotasImpl
implements PlaywrightQuotas {
    private static final ClientLogger LOGGER = new ClientLogger(PlaywrightQuotasImpl.class);
    private final PlaywrightQuotasClient innerClient;
    private final PlaywrightManager serviceManager;

    public PlaywrightQuotasImpl(PlaywrightQuotasClient innerClient, PlaywrightManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PlaywrightQuota> getWithResponse(String location, QuotaName playwrightQuotaName, Context context) {
        Response<PlaywrightQuotaInner> inner = this.serviceClient().getWithResponse(location, playwrightQuotaName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PlaywrightQuotaImpl((PlaywrightQuotaInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PlaywrightQuota get(String location, QuotaName playwrightQuotaName) {
        PlaywrightQuotaInner inner = this.serviceClient().get(location, playwrightQuotaName);
        if (inner != null) {
            return new PlaywrightQuotaImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PlaywrightQuota> listBySubscription(String location) {
        PagedIterable<PlaywrightQuotaInner> inner = this.serviceClient().listBySubscription(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PlaywrightQuotaImpl((PlaywrightQuotaInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PlaywrightQuota> listBySubscription(String location, Context context) {
        PagedIterable<PlaywrightQuotaInner> inner = this.serviceClient().listBySubscription(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PlaywrightQuotaImpl((PlaywrightQuotaInner)((Object)inner1), this.manager()));
    }

    private PlaywrightQuotasClient serviceClient() {
        return this.innerClient;
    }

    private PlaywrightManager manager() {
        return this.serviceManager;
    }
}

