/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.planetarycomputer.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.planetarycomputer.fluent.models.GeoCatalogInner;
import com.azure.resourcemanager.planetarycomputer.models.GeoCatalogProperties;
import com.azure.resourcemanager.planetarycomputer.models.ManagedServiceIdentity;
import com.azure.resourcemanager.planetarycomputer.models.ManagedServiceIdentityUpdate;
import java.util.Map;

public interface GeoCatalog {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public GeoCatalogProperties properties();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public GeoCatalogInner innerModel();

    public Update update();

    public GeoCatalog refresh();

    public GeoCatalog refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentityUpdate var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity {
        public GeoCatalog apply();

        public GeoCatalog apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(GeoCatalogProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties,
        WithIdentity {
            public GeoCatalog create();

            public GeoCatalog create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

