/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.planetarycomputer.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.planetarycomputer.implementation.PlanetaryComputerMgmtClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={PlanetaryComputerMgmtClientImpl.class})
public final class PlanetaryComputerMgmtClientBuilder {
    private String endpoint;
    private String subscriptionId;
    private AzureEnvironment environment;
    private HttpPipeline pipeline;
    private Duration defaultPollInterval;
    private SerializerAdapter serializerAdapter;

    public PlanetaryComputerMgmtClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public PlanetaryComputerMgmtClientBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public PlanetaryComputerMgmtClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public PlanetaryComputerMgmtClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public PlanetaryComputerMgmtClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public PlanetaryComputerMgmtClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public PlanetaryComputerMgmtClientImpl buildClient() {
        String localEndpoint = this.endpoint != null ? this.endpoint : "https://management.azure.com";
        AzureEnvironment localEnvironment = this.environment != null ? this.environment : AzureEnvironment.AZURE;
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build();
        Duration localDefaultPollInterval = this.defaultPollInterval != null ? this.defaultPollInterval : Duration.ofSeconds(30L);
        SerializerAdapter localSerializerAdapter = this.serializerAdapter != null ? this.serializerAdapter : SerializerFactory.createDefaultManagementSerializerAdapter();
        PlanetaryComputerMgmtClientImpl client = new PlanetaryComputerMgmtClientImpl(localPipeline, localSerializerAdapter, localDefaultPollInterval, localEnvironment, localEndpoint, this.subscriptionId);
        return client;
    }
}

