/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.planetarycomputer.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.planetarycomputer.models.GeoCatalogProperties;
import com.azure.resourcemanager.planetarycomputer.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class GeoCatalogInner
extends Resource {
    private GeoCatalogProperties properties;
    private ManagedServiceIdentity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public GeoCatalogProperties properties() {
        return this.properties;
    }

    public GeoCatalogInner withProperties(GeoCatalogProperties properties) {
        this.properties = properties;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public GeoCatalogInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public GeoCatalogInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public GeoCatalogInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static GeoCatalogInner fromJson(JsonReader jsonReader) throws IOException {
        return (GeoCatalogInner)((Object)jsonReader.readObject(reader -> {
            GeoCatalogInner deserializedGeoCatalogInner = new GeoCatalogInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGeoCatalogInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGeoCatalogInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGeoCatalogInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedGeoCatalogInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGeoCatalogInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGeoCatalogInner.properties = GeoCatalogProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedGeoCatalogInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedGeoCatalogInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGeoCatalogInner;
        }));
    }
}

