/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.RackInner;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.RackDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.RackProvisioningState;
import java.util.Map;

public interface Rack {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public String availabilityZone();

    public String clusterId();

    public RackDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public RackProvisioningState provisioningState();

    public String rackLocation();

    public String rackSerialNumber();

    public String rackSkuId();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public RackInner innerModel();

    public Update update();

    public Rack refresh();

    public Rack refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithRackSerialNumber {
            public Update withRackSerialNumber(String var1);
        }

        public static interface WithRackLocation {
            public Update withRackLocation(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithRackLocation,
    UpdateStages.WithRackSerialNumber,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public Rack apply();

        public Rack apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIfMatch,
        WithIfNoneMatch {
            public Rack create();

            public Rack create(Context var1);
        }

        public static interface WithRackSkuId {
            public WithCreate withRackSkuId(String var1);
        }

        public static interface WithRackSerialNumber {
            public WithRackSkuId withRackSerialNumber(String var1);
        }

        public static interface WithRackLocation {
            public WithRackSerialNumber withRackLocation(String var1);
        }

        public static interface WithAvailabilityZone {
            public WithRackLocation withAvailabilityZone(String var1);
        }

        public static interface WithExtendedLocation {
            public WithAvailabilityZone withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithAvailabilityZone,
    DefinitionStages.WithRackLocation,
    DefinitionStages.WithRackSerialNumber,
    DefinitionStages.WithRackSkuId,
    DefinitionStages.WithCreate {
    }
}

