/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.CloudServicesNetworkInner;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkProvisioningState;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkStorageOptions;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkStorageOptionsPatch;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkStorageStatus;
import com.azure.resourcemanager.networkcloud.models.EgressEndpoint;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import java.util.List;
import java.util.Map;

public interface CloudServicesNetwork {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public List<EgressEndpoint> additionalEgressEndpoints();

    public List<String> associatedResourceIds();

    public String clusterId();

    public CloudServicesNetworkDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints();

    public List<EgressEndpoint> enabledEgressEndpoints();

    public List<String> hybridAksClustersAssociatedIds();

    public String interfaceName();

    public CloudServicesNetworkProvisioningState provisioningState();

    public CloudServicesNetworkStorageOptions storageOptions();

    public CloudServicesNetworkStorageStatus storageStatus();

    public List<String> virtualMachinesAssociatedIds();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public CloudServicesNetworkInner innerModel();

    public Update update();

    public CloudServicesNetwork refresh();

    public CloudServicesNetwork refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithStorageOptions {
            public Update withStorageOptions(CloudServicesNetworkStorageOptionsPatch var1);
        }

        public static interface WithEnableDefaultEgressEndpoints {
            public Update withEnableDefaultEgressEndpoints(CloudServicesNetworkEnableDefaultEgressEndpoints var1);
        }

        public static interface WithAdditionalEgressEndpoints {
            public Update withAdditionalEgressEndpoints(List<EgressEndpoint> var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithAdditionalEgressEndpoints,
    UpdateStages.WithEnableDefaultEgressEndpoints,
    UpdateStages.WithStorageOptions,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public CloudServicesNetwork apply();

        public CloudServicesNetwork apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithStorageOptions {
            public WithCreate withStorageOptions(CloudServicesNetworkStorageOptions var1);
        }

        public static interface WithEnableDefaultEgressEndpoints {
            public WithCreate withEnableDefaultEgressEndpoints(CloudServicesNetworkEnableDefaultEgressEndpoints var1);
        }

        public static interface WithAdditionalEgressEndpoints {
            public WithCreate withAdditionalEgressEndpoints(List<EgressEndpoint> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithAdditionalEgressEndpoints,
        WithEnableDefaultEgressEndpoints,
        WithStorageOptions,
        WithIfMatch,
        WithIfNoneMatch {
            public CloudServicesNetwork create();

            public CloudServicesNetwork create(Context var1);
        }

        public static interface WithExtendedLocation {
            public WithCreate withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithCreate {
    }
}

