/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.AgentPoolPatchProperties;
import com.azure.resourcemanager.networkcloud.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.networkcloud.models.NodePoolAdministratorConfigurationPatch;
import java.io.IOException;
import java.util.Map;

public final class AgentPoolPatchParameters
implements JsonSerializable<AgentPoolPatchParameters> {
    private AgentPoolPatchProperties innerProperties;
    private Map<String, String> tags;

    private AgentPoolPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public AgentPoolPatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public NodePoolAdministratorConfigurationPatch administratorConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorConfiguration();
    }

    public AgentPoolPatchParameters withAdministratorConfiguration(NodePoolAdministratorConfigurationPatch administratorConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolPatchProperties();
        }
        this.innerProperties().withAdministratorConfiguration(administratorConfiguration);
        return this;
    }

    public Long count() {
        return this.innerProperties() == null ? null : this.innerProperties().count();
    }

    public AgentPoolPatchParameters withCount(Long count) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolPatchProperties();
        }
        this.innerProperties().withCount(count);
        return this;
    }

    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradeSettings();
    }

    public AgentPoolPatchParameters withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolPatchProperties();
        }
        this.innerProperties().withUpgradeSettings(upgradeSettings);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolPatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolPatchParameters)jsonReader.readObject(reader -> {
            AgentPoolPatchParameters deserializedAgentPoolPatchParameters = new AgentPoolPatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedAgentPoolPatchParameters.innerProperties = AgentPoolPatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedAgentPoolPatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolPatchParameters;
        });
    }
}

