/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ActionStateStatus;
import com.azure.resourcemanager.networkcloud.models.StepState;
import java.io.IOException;
import java.util.List;

public final class ActionState
implements JsonSerializable<ActionState> {
    private String actionType;
    private String correlationId;
    private String endTime;
    private String message;
    private String startTime;
    private ActionStateStatus status;
    private List<StepState> stepStates;

    public String actionType() {
        return this.actionType;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public String endTime() {
        return this.endTime;
    }

    public String message() {
        return this.message;
    }

    public String startTime() {
        return this.startTime;
    }

    public ActionStateStatus status() {
        return this.status;
    }

    public List<StepState> stepStates() {
        return this.stepStates;
    }

    public void validate() {
        if (this.stepStates() != null) {
            this.stepStates().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ActionState fromJson(JsonReader jsonReader) throws IOException {
        return (ActionState)jsonReader.readObject(reader -> {
            ActionState deserializedActionState = new ActionState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actionType".equals(fieldName)) {
                    deserializedActionState.actionType = reader.getString();
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedActionState.correlationId = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedActionState.endTime = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedActionState.message = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedActionState.startTime = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedActionState.status = ActionStateStatus.fromString(reader.getString());
                    continue;
                }
                if ("stepStates".equals(fieldName)) {
                    List stepStates;
                    deserializedActionState.stepStates = stepStates = reader.readArray(reader1 -> StepState.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActionState;
        });
    }
}

