/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.ClustersClient;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.ClusterImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.Cluster;
import com.azure.resourcemanager.networkcloud.models.ClusterContinueUpdateVersionParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterDeployParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterScanRuntimeParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateVersionParameters;
import com.azure.resourcemanager.networkcloud.models.Clusters;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class ClustersImpl
implements Clusters {
    private static final ClientLogger LOGGER = new ClientLogger(ClustersImpl.class);
    private final ClustersClient innerClient;
    private final NetworkCloudManager serviceManager;

    public ClustersImpl(ClustersClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Cluster> list() {
        PagedIterable<ClusterInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterImpl((ClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cluster> list(Integer top, String skipToken, Context context) {
        PagedIterable<ClusterInner> inner = this.serviceClient().list(top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterImpl((ClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cluster> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ClusterInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterImpl((ClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cluster> listByResourceGroup(String resourceGroupName, Integer top, String skipToken, Context context) {
        PagedIterable<ClusterInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterImpl((ClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Cluster> getByResourceGroupWithResponse(String resourceGroupName, String clusterName, Context context) {
        Response<ClusterInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, clusterName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ClusterImpl((ClusterInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Cluster getByResourceGroup(String resourceGroupName, String clusterName) {
        ClusterInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, clusterName);
        if (inner != null) {
            return new ClusterImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String clusterName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String clusterName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult continueUpdateVersion(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters) {
        OperationStatusResultInner inner = this.serviceClient().continueUpdateVersion(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult continueUpdateVersion(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().continueUpdateVersion(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deploy(String resourceGroupName, String clusterName) {
        OperationStatusResultInner inner = this.serviceClient().deploy(resourceGroupName, clusterName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deploy(String resourceGroupName, String clusterName, ClusterDeployParameters clusterDeployParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().deploy(resourceGroupName, clusterName, clusterDeployParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult scanRuntime(String resourceGroupName, String clusterName) {
        OperationStatusResultInner inner = this.serviceClient().scanRuntime(resourceGroupName, clusterName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult scanRuntime(String resourceGroupName, String clusterName, ClusterScanRuntimeParameters clusterScanRuntimeParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().scanRuntime(resourceGroupName, clusterName, clusterScanRuntimeParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult updateVersion(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters) {
        OperationStatusResultInner inner = this.serviceClient().updateVersion(resourceGroupName, clusterName, clusterUpdateVersionParameters);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult updateVersion(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().updateVersion(resourceGroupName, clusterName, clusterUpdateVersionParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Cluster getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        return (Cluster)this.getByResourceGroupWithResponse(resourceGroupName, clusterName, Context.NONE).getValue();
    }

    @Override
    public Response<Cluster> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, clusterName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, clusterName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        return this.delete(resourceGroupName, clusterName, ifMatch, ifNoneMatch, context);
    }

    private ClustersClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterImpl define(String name) {
        return new ClusterImpl(name, this.manager());
    }
}

