/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.BareMetalMachineKeySetsClient;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineKeySetInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.BareMetalMachineKeySetImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySet;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySets;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class BareMetalMachineKeySetsImpl
implements BareMetalMachineKeySets {
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachineKeySetsImpl.class);
    private final BareMetalMachineKeySetsClient innerClient;
    private final NetworkCloudManager serviceManager;

    public BareMetalMachineKeySetsImpl(BareMetalMachineKeySetsClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BareMetalMachineKeySet> listByCluster(String resourceGroupName, String clusterName) {
        PagedIterable<BareMetalMachineKeySetInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BareMetalMachineKeySetImpl((BareMetalMachineKeySetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BareMetalMachineKeySet> listByCluster(String resourceGroupName, String clusterName, Integer top, String skipToken, Context context) {
        PagedIterable<BareMetalMachineKeySetInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName, top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BareMetalMachineKeySetImpl((BareMetalMachineKeySetInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<BareMetalMachineKeySet> getWithResponse(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, Context context) {
        Response<BareMetalMachineKeySetInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, bareMetalMachineKeySetName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BareMetalMachineKeySetImpl((BareMetalMachineKeySetInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BareMetalMachineKeySet get(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        BareMetalMachineKeySetInner inner = this.serviceClient().get(resourceGroupName, clusterName, bareMetalMachineKeySetName);
        if (inner != null) {
            return new BareMetalMachineKeySetImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterName, bareMetalMachineKeySetName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterName, bareMetalMachineKeySetName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BareMetalMachineKeySet getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String bareMetalMachineKeySetName = ResourceManagerUtils.getValueFromIdByName(id, "bareMetalMachineKeySets");
        if (bareMetalMachineKeySetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bareMetalMachineKeySets'.", id)));
        }
        return (BareMetalMachineKeySet)this.getWithResponse(resourceGroupName, clusterName, bareMetalMachineKeySetName, Context.NONE).getValue();
    }

    @Override
    public Response<BareMetalMachineKeySet> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String bareMetalMachineKeySetName = ResourceManagerUtils.getValueFromIdByName(id, "bareMetalMachineKeySets");
        if (bareMetalMachineKeySetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bareMetalMachineKeySets'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, bareMetalMachineKeySetName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String bareMetalMachineKeySetName = ResourceManagerUtils.getValueFromIdByName(id, "bareMetalMachineKeySets");
        if (bareMetalMachineKeySetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bareMetalMachineKeySets'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, clusterName, bareMetalMachineKeySetName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String bareMetalMachineKeySetName = ResourceManagerUtils.getValueFromIdByName(id, "bareMetalMachineKeySets");
        if (bareMetalMachineKeySetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bareMetalMachineKeySets'.", id)));
        }
        return this.delete(resourceGroupName, clusterName, bareMetalMachineKeySetName, ifMatch, ifNoneMatch, context);
    }

    private BareMetalMachineKeySetsClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public BareMetalMachineKeySetImpl define(String name) {
        return new BareMetalMachineKeySetImpl(name, this.manager());
    }
}

