/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.TrunkedNetworkInner;
import java.io.IOException;
import java.util.List;

public final class TrunkedNetworkList
implements JsonSerializable<TrunkedNetworkList> {
    private String nextLink;
    private List<TrunkedNetworkInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public TrunkedNetworkList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<TrunkedNetworkInner> value() {
        return this.value;
    }

    public TrunkedNetworkList withValue(List<TrunkedNetworkInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TrunkedNetworkList fromJson(JsonReader jsonReader) throws IOException {
        return (TrunkedNetworkList)jsonReader.readObject(reader -> {
            TrunkedNetworkList deserializedTrunkedNetworkList = new TrunkedNetworkList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedTrunkedNetworkList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedTrunkedNetworkList.value = value = reader.readArray(reader1 -> TrunkedNetworkInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrunkedNetworkList;
        });
    }
}

