/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.BfdEnabled;
import com.azure.resourcemanager.networkcloud.models.BgpMultiHop;
import java.io.IOException;

public final class ServiceLoadBalancerBgpPeer
implements JsonSerializable<ServiceLoadBalancerBgpPeer> {
    private BfdEnabled bfdEnabled;
    private BgpMultiHop bgpMultiHop;
    private String holdTime;
    private String keepAliveTime;
    private Long myAsn;
    private String name;
    private String password;
    private String peerAddress;
    private long peerAsn;
    private Long peerPort;
    private static final ClientLogger LOGGER = new ClientLogger(ServiceLoadBalancerBgpPeer.class);

    public BfdEnabled bfdEnabled() {
        return this.bfdEnabled;
    }

    public ServiceLoadBalancerBgpPeer withBfdEnabled(BfdEnabled bfdEnabled) {
        this.bfdEnabled = bfdEnabled;
        return this;
    }

    public BgpMultiHop bgpMultiHop() {
        return this.bgpMultiHop;
    }

    public ServiceLoadBalancerBgpPeer withBgpMultiHop(BgpMultiHop bgpMultiHop) {
        this.bgpMultiHop = bgpMultiHop;
        return this;
    }

    public String holdTime() {
        return this.holdTime;
    }

    public ServiceLoadBalancerBgpPeer withHoldTime(String holdTime) {
        this.holdTime = holdTime;
        return this;
    }

    public String keepAliveTime() {
        return this.keepAliveTime;
    }

    public ServiceLoadBalancerBgpPeer withKeepAliveTime(String keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    public Long myAsn() {
        return this.myAsn;
    }

    public ServiceLoadBalancerBgpPeer withMyAsn(Long myAsn) {
        this.myAsn = myAsn;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ServiceLoadBalancerBgpPeer withName(String name) {
        this.name = name;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ServiceLoadBalancerBgpPeer withPassword(String password) {
        this.password = password;
        return this;
    }

    public String peerAddress() {
        return this.peerAddress;
    }

    public ServiceLoadBalancerBgpPeer withPeerAddress(String peerAddress) {
        this.peerAddress = peerAddress;
        return this;
    }

    public long peerAsn() {
        return this.peerAsn;
    }

    public ServiceLoadBalancerBgpPeer withPeerAsn(long peerAsn) {
        this.peerAsn = peerAsn;
        return this;
    }

    public Long peerPort() {
        return this.peerPort;
    }

    public ServiceLoadBalancerBgpPeer withPeerPort(Long peerPort) {
        this.peerPort = peerPort;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ServiceLoadBalancerBgpPeer"));
        }
        if (this.peerAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property peerAddress in model ServiceLoadBalancerBgpPeer"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("peerAddress", this.peerAddress);
        jsonWriter.writeLongField("peerAsn", this.peerAsn);
        jsonWriter.writeStringField("bfdEnabled", this.bfdEnabled == null ? null : this.bfdEnabled.toString());
        jsonWriter.writeStringField("bgpMultiHop", this.bgpMultiHop == null ? null : this.bgpMultiHop.toString());
        jsonWriter.writeStringField("holdTime", this.holdTime);
        jsonWriter.writeStringField("keepAliveTime", this.keepAliveTime);
        jsonWriter.writeNumberField("myAsn", (Number)this.myAsn);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeNumberField("peerPort", (Number)this.peerPort);
        return jsonWriter.writeEndObject();
    }

    public static ServiceLoadBalancerBgpPeer fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceLoadBalancerBgpPeer)jsonReader.readObject(reader -> {
            ServiceLoadBalancerBgpPeer deserializedServiceLoadBalancerBgpPeer = new ServiceLoadBalancerBgpPeer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.name = reader.getString();
                    continue;
                }
                if ("peerAddress".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.peerAddress = reader.getString();
                    continue;
                }
                if ("peerAsn".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.peerAsn = reader.getLong();
                    continue;
                }
                if ("bfdEnabled".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.bfdEnabled = BfdEnabled.fromString(reader.getString());
                    continue;
                }
                if ("bgpMultiHop".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.bgpMultiHop = BgpMultiHop.fromString(reader.getString());
                    continue;
                }
                if ("holdTime".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.holdTime = reader.getString();
                    continue;
                }
                if ("keepAliveTime".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.keepAliveTime = reader.getString();
                    continue;
                }
                if ("myAsn".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.myAsn = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.password = reader.getString();
                    continue;
                }
                if ("peerPort".equals(fieldName)) {
                    deserializedServiceLoadBalancerBgpPeer.peerPort = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceLoadBalancerBgpPeer;
        });
    }
}

