/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.SecretArchiveReference;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SecretRotationStatus
implements JsonSerializable<SecretRotationStatus> {
    private Long expirePeriodDays;
    private OffsetDateTime lastRotationTime;
    private Long rotationPeriodDays;
    private SecretArchiveReference secretArchiveReference;
    private String secretType;

    public Long expirePeriodDays() {
        return this.expirePeriodDays;
    }

    public OffsetDateTime lastRotationTime() {
        return this.lastRotationTime;
    }

    public Long rotationPeriodDays() {
        return this.rotationPeriodDays;
    }

    public SecretArchiveReference secretArchiveReference() {
        return this.secretArchiveReference;
    }

    public String secretType() {
        return this.secretType;
    }

    public void validate() {
        if (this.secretArchiveReference() != null) {
            this.secretArchiveReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SecretRotationStatus fromJson(JsonReader jsonReader) throws IOException {
        return (SecretRotationStatus)jsonReader.readObject(reader -> {
            SecretRotationStatus deserializedSecretRotationStatus = new SecretRotationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expirePeriodDays".equals(fieldName)) {
                    deserializedSecretRotationStatus.expirePeriodDays = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("lastRotationTime".equals(fieldName)) {
                    deserializedSecretRotationStatus.lastRotationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("rotationPeriodDays".equals(fieldName)) {
                    deserializedSecretRotationStatus.rotationPeriodDays = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("secretArchiveReference".equals(fieldName)) {
                    deserializedSecretRotationStatus.secretArchiveReference = SecretArchiveReference.fromJson(reader);
                    continue;
                }
                if ("secretType".equals(fieldName)) {
                    deserializedSecretRotationStatus.secretType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretRotationStatus;
        });
    }
}

