/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.IpAddressPool;
import java.io.IOException;
import java.util.List;

public final class L2ServiceLoadBalancerConfiguration
implements JsonSerializable<L2ServiceLoadBalancerConfiguration> {
    private List<IpAddressPool> ipAddressPools;

    public List<IpAddressPool> ipAddressPools() {
        return this.ipAddressPools;
    }

    public L2ServiceLoadBalancerConfiguration withIpAddressPools(List<IpAddressPool> ipAddressPools) {
        this.ipAddressPools = ipAddressPools;
        return this;
    }

    public void validate() {
        if (this.ipAddressPools() != null) {
            this.ipAddressPools().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipAddressPools", this.ipAddressPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static L2ServiceLoadBalancerConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (L2ServiceLoadBalancerConfiguration)jsonReader.readObject(reader -> {
            L2ServiceLoadBalancerConfiguration deserializedL2ServiceLoadBalancerConfiguration = new L2ServiceLoadBalancerConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipAddressPools".equals(fieldName)) {
                    List ipAddressPools;
                    deserializedL2ServiceLoadBalancerConfiguration.ipAddressPools = ipAddressPools = reader.readArray(reader1 -> IpAddressPool.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedL2ServiceLoadBalancerConfiguration;
        });
    }
}

