/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.L2NetworkInner;
import java.io.IOException;
import java.util.List;

public final class L2NetworkList
implements JsonSerializable<L2NetworkList> {
    private String nextLink;
    private List<L2NetworkInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public L2NetworkList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<L2NetworkInner> value() {
        return this.value;
    }

    public L2NetworkList withValue(List<L2NetworkInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static L2NetworkList fromJson(JsonReader jsonReader) throws IOException {
        return (L2NetworkList)jsonReader.readObject(reader -> {
            L2NetworkList deserializedL2NetworkList = new L2NetworkList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedL2NetworkList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedL2NetworkList.value = value = reader.readArray(reader1 -> L2NetworkInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedL2NetworkList;
        });
    }
}

