/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfigurationPatch;
import java.io.IOException;

public final class ControlPlaneNodePatchConfiguration
implements JsonSerializable<ControlPlaneNodePatchConfiguration> {
    private AdministratorConfigurationPatch administratorConfiguration;
    private Long count;

    public AdministratorConfigurationPatch administratorConfiguration() {
        return this.administratorConfiguration;
    }

    public ControlPlaneNodePatchConfiguration withAdministratorConfiguration(AdministratorConfigurationPatch administratorConfiguration) {
        this.administratorConfiguration = administratorConfiguration;
        return this;
    }

    public Long count() {
        return this.count;
    }

    public ControlPlaneNodePatchConfiguration withCount(Long count) {
        this.count = count;
        return this;
    }

    public void validate() {
        if (this.administratorConfiguration() != null) {
            this.administratorConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("administratorConfiguration", (JsonSerializable)this.administratorConfiguration);
        jsonWriter.writeNumberField("count", (Number)this.count);
        return jsonWriter.writeEndObject();
    }

    public static ControlPlaneNodePatchConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ControlPlaneNodePatchConfiguration)jsonReader.readObject(reader -> {
            ControlPlaneNodePatchConfiguration deserializedControlPlaneNodePatchConfiguration = new ControlPlaneNodePatchConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorConfiguration".equals(fieldName)) {
                    deserializedControlPlaneNodePatchConfiguration.administratorConfiguration = AdministratorConfigurationPatch.fromJson(reader);
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedControlPlaneNodePatchConfiguration.count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedControlPlaneNodePatchConfiguration;
        });
    }
}

