/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterPatchProperties;
import com.azure.resourcemanager.networkcloud.models.AnalyticsOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ClusterSecretArchive;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateStrategy;
import com.azure.resourcemanager.networkcloud.models.CommandOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentity;
import com.azure.resourcemanager.networkcloud.models.RackDefinition;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionConfiguration;
import com.azure.resourcemanager.networkcloud.models.SecretArchiveSettings;
import com.azure.resourcemanager.networkcloud.models.ServicePrincipalInformation;
import com.azure.resourcemanager.networkcloud.models.ValidationThreshold;
import com.azure.resourcemanager.networkcloud.models.VulnerabilityScanningSettingsPatch;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ClusterPatchParameters
implements JsonSerializable<ClusterPatchParameters> {
    private ManagedServiceIdentity identity;
    private ClusterPatchProperties innerProperties;
    private Map<String, String> tags;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ClusterPatchParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ClusterPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ClusterPatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public RackDefinition aggregatorOrSingleRackDefinition() {
        return this.innerProperties() == null ? null : this.innerProperties().aggregatorOrSingleRackDefinition();
    }

    public ClusterPatchParameters withAggregatorOrSingleRackDefinition(RackDefinition aggregatorOrSingleRackDefinition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withAggregatorOrSingleRackDefinition(aggregatorOrSingleRackDefinition);
        return this;
    }

    public AnalyticsOutputSettings analyticsOutputSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().analyticsOutputSettings();
    }

    public ClusterPatchParameters withAnalyticsOutputSettings(AnalyticsOutputSettings analyticsOutputSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withAnalyticsOutputSettings(analyticsOutputSettings);
        return this;
    }

    public String clusterLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterLocation();
    }

    public ClusterPatchParameters withClusterLocation(String clusterLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withClusterLocation(clusterLocation);
        return this;
    }

    public ServicePrincipalInformation clusterServicePrincipal() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterServicePrincipal();
    }

    public ClusterPatchParameters withClusterServicePrincipal(ServicePrincipalInformation clusterServicePrincipal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withClusterServicePrincipal(clusterServicePrincipal);
        return this;
    }

    public CommandOutputSettings commandOutputSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().commandOutputSettings();
    }

    public ClusterPatchParameters withCommandOutputSettings(CommandOutputSettings commandOutputSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withCommandOutputSettings(commandOutputSettings);
        return this;
    }

    public ValidationThreshold computeDeploymentThreshold() {
        return this.innerProperties() == null ? null : this.innerProperties().computeDeploymentThreshold();
    }

    public ClusterPatchParameters withComputeDeploymentThreshold(ValidationThreshold computeDeploymentThreshold) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withComputeDeploymentThreshold(computeDeploymentThreshold);
        return this;
    }

    public List<RackDefinition> computeRackDefinitions() {
        return this.innerProperties() == null ? null : this.innerProperties().computeRackDefinitions();
    }

    public ClusterPatchParameters withComputeRackDefinitions(List<RackDefinition> computeRackDefinitions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withComputeRackDefinitions(computeRackDefinitions);
        return this;
    }

    public RuntimeProtectionConfiguration runtimeProtectionConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().runtimeProtectionConfiguration();
    }

    public ClusterPatchParameters withRuntimeProtectionConfiguration(RuntimeProtectionConfiguration runtimeProtectionConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withRuntimeProtectionConfiguration(runtimeProtectionConfiguration);
        return this;
    }

    public ClusterSecretArchive secretArchive() {
        return this.innerProperties() == null ? null : this.innerProperties().secretArchive();
    }

    public ClusterPatchParameters withSecretArchive(ClusterSecretArchive secretArchive) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withSecretArchive(secretArchive);
        return this;
    }

    public SecretArchiveSettings secretArchiveSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().secretArchiveSettings();
    }

    public ClusterPatchParameters withSecretArchiveSettings(SecretArchiveSettings secretArchiveSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withSecretArchiveSettings(secretArchiveSettings);
        return this;
    }

    public ClusterUpdateStrategy updateStrategy() {
        return this.innerProperties() == null ? null : this.innerProperties().updateStrategy();
    }

    public ClusterPatchParameters withUpdateStrategy(ClusterUpdateStrategy updateStrategy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withUpdateStrategy(updateStrategy);
        return this;
    }

    public VulnerabilityScanningSettingsPatch vulnerabilityScanningSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().vulnerabilityScanningSettings();
    }

    public ClusterPatchParameters withVulnerabilityScanningSettings(VulnerabilityScanningSettingsPatch vulnerabilityScanningSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withVulnerabilityScanningSettings(vulnerabilityScanningSettings);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ClusterPatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterPatchParameters)jsonReader.readObject(reader -> {
            ClusterPatchParameters deserializedClusterPatchParameters = new ClusterPatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedClusterPatchParameters.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClusterPatchParameters.innerProperties = ClusterPatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedClusterPatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterPatchParameters;
        });
    }
}

