/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterManagerInner;
import com.azure.resourcemanager.networkcloud.models.ClusterAvailableVersion;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentity;
import java.util.List;
import java.util.Map;

public interface ClusterManager {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public String analyticsWorkspaceId();

    public List<String> availabilityZones();

    public List<ClusterAvailableVersion> clusterVersions();

    public ClusterManagerDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public String fabricControllerId();

    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration();

    public ExtendedLocation managerExtendedLocation();

    public ClusterManagerProvisioningState provisioningState();

    public String vmSize();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ClusterManagerInner innerModel();

    public Update update();

    public ClusterManager refresh();

    public ClusterManager refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public ClusterManager apply();

        public ClusterManager apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithVmSize {
            public WithCreate withVmSize(String var1);
        }

        public static interface WithManagedResourceGroupConfiguration {
            public WithCreate withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration var1);
        }

        public static interface WithAvailabilityZones {
            public WithCreate withAvailabilityZones(List<String> var1);
        }

        public static interface WithAnalyticsWorkspaceId {
            public WithCreate withAnalyticsWorkspaceId(String var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithAnalyticsWorkspaceId,
        WithAvailabilityZones,
        WithManagedResourceGroupConfiguration,
        WithVmSize,
        WithIfMatch,
        WithIfNoneMatch {
            public ClusterManager create();

            public ClusterManager create(Context var1);
        }

        public static interface WithFabricControllerId {
            public WithCreate withFabricControllerId(String var1);
        }

        public static interface WithResourceGroup {
            public WithFabricControllerId withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithFabricControllerId,
    DefinitionStages.WithCreate {
    }
}

