/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.BmcKeySetInner;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetPrivilegeLevel;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import com.azure.resourcemanager.networkcloud.models.KeySetUserStatus;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface BmcKeySet {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public String azureGroupId();

    public BmcKeySetDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public OffsetDateTime expiration();

    public OffsetDateTime lastValidation();

    public BmcKeySetPrivilegeLevel privilegeLevel();

    public BmcKeySetProvisioningState provisioningState();

    public List<KeySetUser> userList();

    public List<KeySetUserStatus> userListStatus();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public BmcKeySetInner innerModel();

    public Update update();

    public BmcKeySet refresh();

    public BmcKeySet refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithUserList {
            public Update withUserList(List<KeySetUser> var1);
        }

        public static interface WithExpiration {
            public Update withExpiration(OffsetDateTime var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithExpiration,
    UpdateStages.WithUserList,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public BmcKeySet apply();

        public BmcKeySet apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIfMatch,
        WithIfNoneMatch {
            public BmcKeySet create();

            public BmcKeySet create(Context var1);
        }

        public static interface WithUserList {
            public WithCreate withUserList(List<KeySetUser> var1);
        }

        public static interface WithPrivilegeLevel {
            public WithUserList withPrivilegeLevel(BmcKeySetPrivilegeLevel var1);
        }

        public static interface WithExpiration {
            public WithPrivilegeLevel withExpiration(OffsetDateTime var1);
        }

        public static interface WithAzureGroupId {
            public WithExpiration withAzureGroupId(String var1);
        }

        public static interface WithExtendedLocation {
            public WithAzureGroupId withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithParentResource {
            public WithExtendedLocation withExistingCluster(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithAzureGroupId,
    DefinitionStages.WithExpiration,
    DefinitionStages.WithPrivilegeLevel,
    DefinitionStages.WithUserList,
    DefinitionStages.WithCreate {
    }
}

