/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import java.io.IOException;

public final class BareMetalMachineReplaceParameters
implements JsonSerializable<BareMetalMachineReplaceParameters> {
    private AdministrativeCredentials bmcCredentials;
    private String bmcMacAddress;
    private String bootMacAddress;
    private String machineName;
    private String serialNumber;

    public AdministrativeCredentials bmcCredentials() {
        return this.bmcCredentials;
    }

    public BareMetalMachineReplaceParameters withBmcCredentials(AdministrativeCredentials bmcCredentials) {
        this.bmcCredentials = bmcCredentials;
        return this;
    }

    public String bmcMacAddress() {
        return this.bmcMacAddress;
    }

    public BareMetalMachineReplaceParameters withBmcMacAddress(String bmcMacAddress) {
        this.bmcMacAddress = bmcMacAddress;
        return this;
    }

    public String bootMacAddress() {
        return this.bootMacAddress;
    }

    public BareMetalMachineReplaceParameters withBootMacAddress(String bootMacAddress) {
        this.bootMacAddress = bootMacAddress;
        return this;
    }

    public String machineName() {
        return this.machineName;
    }

    public BareMetalMachineReplaceParameters withMachineName(String machineName) {
        this.machineName = machineName;
        return this;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public BareMetalMachineReplaceParameters withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public void validate() {
        if (this.bmcCredentials() != null) {
            this.bmcCredentials().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("bmcCredentials", (JsonSerializable)this.bmcCredentials);
        jsonWriter.writeStringField("bmcMacAddress", this.bmcMacAddress);
        jsonWriter.writeStringField("bootMacAddress", this.bootMacAddress);
        jsonWriter.writeStringField("machineName", this.machineName);
        jsonWriter.writeStringField("serialNumber", this.serialNumber);
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineReplaceParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineReplaceParameters)jsonReader.readObject(reader -> {
            BareMetalMachineReplaceParameters deserializedBareMetalMachineReplaceParameters = new BareMetalMachineReplaceParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bmcCredentials".equals(fieldName)) {
                    deserializedBareMetalMachineReplaceParameters.bmcCredentials = AdministrativeCredentials.fromJson(reader);
                    continue;
                }
                if ("bmcMacAddress".equals(fieldName)) {
                    deserializedBareMetalMachineReplaceParameters.bmcMacAddress = reader.getString();
                    continue;
                }
                if ("bootMacAddress".equals(fieldName)) {
                    deserializedBareMetalMachineReplaceParameters.bootMacAddress = reader.getString();
                    continue;
                }
                if ("machineName".equals(fieldName)) {
                    deserializedBareMetalMachineReplaceParameters.machineName = reader.getString();
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedBareMetalMachineReplaceParameters.serialNumber = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineReplaceParameters;
        });
    }
}

