/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.StorageApplianceInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.RemoteVendorManagementFeature;
import com.azure.resourcemanager.networkcloud.models.RemoteVendorManagementStatus;
import com.azure.resourcemanager.networkcloud.models.SecretRotationStatus;
import com.azure.resourcemanager.networkcloud.models.StorageAppliance;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceEnableRemoteVendorManagementParameters;
import com.azure.resourcemanager.networkcloud.models.StorageAppliancePatchParameters;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class StorageApplianceImpl
implements StorageAppliance,
StorageAppliance.Definition,
StorageAppliance.Update {
    private StorageApplianceInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String storageApplianceName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;
    private StorageAppliancePatchParameters updateStorageApplianceUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AdministrativeCredentials administratorCredentials() {
        return this.innerModel().administratorCredentials();
    }

    @Override
    public Long capacity() {
        return this.innerModel().capacity();
    }

    @Override
    public Long capacityUsed() {
        return this.innerModel().capacityUsed();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public StorageApplianceDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public String managementIpv4Address() {
        return this.innerModel().managementIpv4Address();
    }

    @Override
    public String manufacturer() {
        return this.innerModel().manufacturer();
    }

    @Override
    public String model() {
        return this.innerModel().model();
    }

    @Override
    public StorageApplianceProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String rackId() {
        return this.innerModel().rackId();
    }

    @Override
    public long rackSlot() {
        return this.innerModel().rackSlot();
    }

    @Override
    public RemoteVendorManagementFeature remoteVendorManagementFeature() {
        return this.innerModel().remoteVendorManagementFeature();
    }

    @Override
    public RemoteVendorManagementStatus remoteVendorManagementStatus() {
        return this.innerModel().remoteVendorManagementStatus();
    }

    @Override
    public List<SecretRotationStatus> secretRotationStatus() {
        List<SecretRotationStatus> inner = this.innerModel().secretRotationStatus();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String serialNumber() {
        return this.innerModel().serialNumber();
    }

    @Override
    public String storageApplianceSkuId() {
        return this.innerModel().storageApplianceSkuId();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public StorageApplianceInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageApplianceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public StorageAppliance create() {
        this.innerObject = this.serviceManager.serviceClient().getStorageAppliances().createOrUpdate(this.resourceGroupName, this.storageApplianceName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public StorageAppliance create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStorageAppliances().createOrUpdate(this.resourceGroupName, this.storageApplianceName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    StorageApplianceImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new StorageApplianceInner();
        this.serviceManager = serviceManager;
        this.storageApplianceName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public StorageApplianceImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        this.updateStorageApplianceUpdateParameters = new StorageAppliancePatchParameters();
        return this;
    }

    @Override
    public StorageAppliance apply() {
        this.innerObject = this.serviceManager.serviceClient().getStorageAppliances().update(this.resourceGroupName, this.storageApplianceName, this.updateIfMatch, this.updateIfNoneMatch, this.updateStorageApplianceUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public StorageAppliance apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStorageAppliances().update(this.resourceGroupName, this.storageApplianceName, this.updateIfMatch, this.updateIfNoneMatch, this.updateStorageApplianceUpdateParameters, context);
        return this;
    }

    StorageApplianceImpl(StorageApplianceInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.storageApplianceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storageAppliances");
    }

    @Override
    public StorageAppliance refresh() {
        this.innerObject = (StorageApplianceInner)((Object)this.serviceManager.serviceClient().getStorageAppliances().getByResourceGroupWithResponse(this.resourceGroupName, this.storageApplianceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public StorageAppliance refresh(Context context) {
        this.innerObject = (StorageApplianceInner)((Object)this.serviceManager.serviceClient().getStorageAppliances().getByResourceGroupWithResponse(this.resourceGroupName, this.storageApplianceName, context).getValue());
        return this;
    }

    @Override
    public OperationStatusResult disableRemoteVendorManagement() {
        return this.serviceManager.storageAppliances().disableRemoteVendorManagement(this.resourceGroupName, this.storageApplianceName);
    }

    @Override
    public OperationStatusResult disableRemoteVendorManagement(Context context) {
        return this.serviceManager.storageAppliances().disableRemoteVendorManagement(this.resourceGroupName, this.storageApplianceName, context);
    }

    @Override
    public OperationStatusResult enableRemoteVendorManagement() {
        return this.serviceManager.storageAppliances().enableRemoteVendorManagement(this.resourceGroupName, this.storageApplianceName);
    }

    @Override
    public OperationStatusResult enableRemoteVendorManagement(StorageApplianceEnableRemoteVendorManagementParameters storageApplianceEnableRemoteVendorManagementParameters, Context context) {
        return this.serviceManager.storageAppliances().enableRemoteVendorManagement(this.resourceGroupName, this.storageApplianceName, storageApplianceEnableRemoteVendorManagementParameters, context);
    }

    @Override
    public StorageApplianceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public StorageApplianceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public StorageApplianceImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public StorageApplianceImpl withAdministratorCredentials(AdministrativeCredentials administratorCredentials) {
        this.innerModel().withAdministratorCredentials(administratorCredentials);
        return this;
    }

    @Override
    public StorageApplianceImpl withRackId(String rackId) {
        this.innerModel().withRackId(rackId);
        return this;
    }

    @Override
    public StorageApplianceImpl withRackSlot(long rackSlot) {
        this.innerModel().withRackSlot(rackSlot);
        return this;
    }

    @Override
    public StorageApplianceImpl withSerialNumber(String serialNumber) {
        if (this.isInCreateMode()) {
            this.innerModel().withSerialNumber(serialNumber);
            return this;
        }
        this.updateStorageApplianceUpdateParameters.withSerialNumber(serialNumber);
        return this;
    }

    @Override
    public StorageApplianceImpl withStorageApplianceSkuId(String storageApplianceSkuId) {
        this.innerModel().withStorageApplianceSkuId(storageApplianceSkuId);
        return this;
    }

    @Override
    public StorageApplianceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateStorageApplianceUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public StorageApplianceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public StorageApplianceImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

