/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterFeatureInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeature;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureAvailabilityLifecycle;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeaturePatchParameters;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureProvisioningState;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureRequired;
import com.azure.resourcemanager.networkcloud.models.StringKeyValuePair;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class KubernetesClusterFeatureImpl
implements KubernetesClusterFeature,
KubernetesClusterFeature.Definition,
KubernetesClusterFeature.Update {
    private KubernetesClusterFeatureInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String kubernetesClusterName;
    private String featureName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;
    private KubernetesClusterFeaturePatchParameters updateKubernetesClusterFeatureUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public KubernetesClusterFeatureAvailabilityLifecycle availabilityLifecycle() {
        return this.innerModel().availabilityLifecycle();
    }

    @Override
    public KubernetesClusterFeatureDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public List<StringKeyValuePair> options() {
        List<StringKeyValuePair> inner = this.innerModel().options();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public KubernetesClusterFeatureProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public KubernetesClusterFeatureRequired required() {
        return this.innerModel().required();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public KubernetesClusterFeatureInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public KubernetesClusterFeatureImpl withExistingKubernetesCluster(String resourceGroupName, String kubernetesClusterName) {
        this.resourceGroupName = resourceGroupName;
        this.kubernetesClusterName = kubernetesClusterName;
        return this;
    }

    @Override
    public KubernetesClusterFeature create() {
        this.innerObject = this.serviceManager.serviceClient().getKubernetesClusterFeatures().createOrUpdate(this.resourceGroupName, this.kubernetesClusterName, this.featureName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public KubernetesClusterFeature create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getKubernetesClusterFeatures().createOrUpdate(this.resourceGroupName, this.kubernetesClusterName, this.featureName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    KubernetesClusterFeatureImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new KubernetesClusterFeatureInner();
        this.serviceManager = serviceManager;
        this.featureName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public KubernetesClusterFeatureImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        this.updateKubernetesClusterFeatureUpdateParameters = new KubernetesClusterFeaturePatchParameters();
        return this;
    }

    @Override
    public KubernetesClusterFeature apply() {
        this.innerObject = this.serviceManager.serviceClient().getKubernetesClusterFeatures().update(this.resourceGroupName, this.kubernetesClusterName, this.featureName, this.updateIfMatch, this.updateIfNoneMatch, this.updateKubernetesClusterFeatureUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public KubernetesClusterFeature apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getKubernetesClusterFeatures().update(this.resourceGroupName, this.kubernetesClusterName, this.featureName, this.updateIfMatch, this.updateIfNoneMatch, this.updateKubernetesClusterFeatureUpdateParameters, context);
        return this;
    }

    KubernetesClusterFeatureImpl(KubernetesClusterFeatureInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "kubernetesClusters");
        this.featureName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "features");
    }

    @Override
    public KubernetesClusterFeature refresh() {
        this.innerObject = (KubernetesClusterFeatureInner)((Object)this.serviceManager.serviceClient().getKubernetesClusterFeatures().getWithResponse(this.resourceGroupName, this.kubernetesClusterName, this.featureName, Context.NONE).getValue());
        return this;
    }

    @Override
    public KubernetesClusterFeature refresh(Context context) {
        this.innerObject = (KubernetesClusterFeatureInner)((Object)this.serviceManager.serviceClient().getKubernetesClusterFeatures().getWithResponse(this.resourceGroupName, this.kubernetesClusterName, this.featureName, context).getValue());
        return this;
    }

    @Override
    public KubernetesClusterFeatureImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public KubernetesClusterFeatureImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public KubernetesClusterFeatureImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateKubernetesClusterFeatureUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public KubernetesClusterFeatureImpl withOptions(List<StringKeyValuePair> options) {
        if (this.isInCreateMode()) {
            this.innerModel().withOptions(options);
            return this;
        }
        this.updateKubernetesClusterFeatureUpdateParameters.withOptions(options);
        return this;
    }

    @Override
    public KubernetesClusterFeatureImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public KubernetesClusterFeatureImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

