/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.BmcKeySetInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.BmcKeySet;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetPatchParameters;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetPrivilegeLevel;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import com.azure.resourcemanager.networkcloud.models.KeySetUserStatus;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BmcKeySetImpl
implements BmcKeySet,
BmcKeySet.Definition,
BmcKeySet.Update {
    private BmcKeySetInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String bmcKeySetName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;
    private BmcKeySetPatchParameters updateBmcKeySetUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String azureGroupId() {
        return this.innerModel().azureGroupId();
    }

    @Override
    public BmcKeySetDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public OffsetDateTime expiration() {
        return this.innerModel().expiration();
    }

    @Override
    public OffsetDateTime lastValidation() {
        return this.innerModel().lastValidation();
    }

    @Override
    public BmcKeySetPrivilegeLevel privilegeLevel() {
        return this.innerModel().privilegeLevel();
    }

    @Override
    public BmcKeySetProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<KeySetUser> userList() {
        List<KeySetUser> inner = this.innerModel().userList();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<KeySetUserStatus> userListStatus() {
        List<KeySetUserStatus> inner = this.innerModel().userListStatus();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BmcKeySetInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public BmcKeySetImpl withExistingCluster(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public BmcKeySet create() {
        this.innerObject = this.serviceManager.serviceClient().getBmcKeySets().createOrUpdate(this.resourceGroupName, this.clusterName, this.bmcKeySetName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public BmcKeySet create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBmcKeySets().createOrUpdate(this.resourceGroupName, this.clusterName, this.bmcKeySetName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    BmcKeySetImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new BmcKeySetInner();
        this.serviceManager = serviceManager;
        this.bmcKeySetName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public BmcKeySetImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        this.updateBmcKeySetUpdateParameters = new BmcKeySetPatchParameters();
        return this;
    }

    @Override
    public BmcKeySet apply() {
        this.innerObject = this.serviceManager.serviceClient().getBmcKeySets().update(this.resourceGroupName, this.clusterName, this.bmcKeySetName, this.updateIfMatch, this.updateIfNoneMatch, this.updateBmcKeySetUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public BmcKeySet apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBmcKeySets().update(this.resourceGroupName, this.clusterName, this.bmcKeySetName, this.updateIfMatch, this.updateIfNoneMatch, this.updateBmcKeySetUpdateParameters, context);
        return this;
    }

    BmcKeySetImpl(BmcKeySetInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "clusters");
        this.bmcKeySetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "bmcKeySets");
    }

    @Override
    public BmcKeySet refresh() {
        this.innerObject = (BmcKeySetInner)((Object)this.serviceManager.serviceClient().getBmcKeySets().getWithResponse(this.resourceGroupName, this.clusterName, this.bmcKeySetName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BmcKeySet refresh(Context context) {
        this.innerObject = (BmcKeySetInner)((Object)this.serviceManager.serviceClient().getBmcKeySets().getWithResponse(this.resourceGroupName, this.clusterName, this.bmcKeySetName, context).getValue());
        return this;
    }

    @Override
    public BmcKeySetImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public BmcKeySetImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public BmcKeySetImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public BmcKeySetImpl withAzureGroupId(String azureGroupId) {
        this.innerModel().withAzureGroupId(azureGroupId);
        return this;
    }

    @Override
    public BmcKeySetImpl withExpiration(OffsetDateTime expiration) {
        if (this.isInCreateMode()) {
            this.innerModel().withExpiration(expiration);
            return this;
        }
        this.updateBmcKeySetUpdateParameters.withExpiration(expiration);
        return this;
    }

    @Override
    public BmcKeySetImpl withPrivilegeLevel(BmcKeySetPrivilegeLevel privilegeLevel) {
        this.innerModel().withPrivilegeLevel(privilegeLevel);
        return this;
    }

    @Override
    public BmcKeySetImpl withUserList(List<KeySetUser> userList) {
        if (this.isInCreateMode()) {
            this.innerModel().withUserList(userList);
            return this;
        }
        this.updateBmcKeySetUpdateParameters.withUserList(userList);
        return this;
    }

    @Override
    public BmcKeySetImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBmcKeySetUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public BmcKeySetImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public BmcKeySetImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

