/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterProperties;
import com.azure.resourcemanager.networkcloud.models.AnalyticsOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ClusterAvailableUpgradeVersion;
import com.azure.resourcemanager.networkcloud.models.ClusterCapacity;
import com.azure.resourcemanager.networkcloud.models.ClusterConnectionStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerConnectionStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ClusterSecretArchive;
import com.azure.resourcemanager.networkcloud.models.ClusterType;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateStrategy;
import com.azure.resourcemanager.networkcloud.models.CommandOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentity;
import com.azure.resourcemanager.networkcloud.models.RackDefinition;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionConfiguration;
import com.azure.resourcemanager.networkcloud.models.SecretArchiveSettings;
import com.azure.resourcemanager.networkcloud.models.ServicePrincipalInformation;
import com.azure.resourcemanager.networkcloud.models.ValidationThreshold;
import com.azure.resourcemanager.networkcloud.models.VulnerabilityScanningSettings;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ClusterInner
extends Resource {
    private String etag;
    private ExtendedLocation extendedLocation;
    private ManagedServiceIdentity identity;
    private ClusterProperties innerProperties = new ClusterProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterInner.class);

    public String etag() {
        return this.etag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public ClusterInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ClusterInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public RackDefinition aggregatorOrSingleRackDefinition() {
        return this.innerProperties() == null ? null : this.innerProperties().aggregatorOrSingleRackDefinition();
    }

    public ClusterInner withAggregatorOrSingleRackDefinition(RackDefinition aggregatorOrSingleRackDefinition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withAggregatorOrSingleRackDefinition(aggregatorOrSingleRackDefinition);
        return this;
    }

    public AnalyticsOutputSettings analyticsOutputSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().analyticsOutputSettings();
    }

    public ClusterInner withAnalyticsOutputSettings(AnalyticsOutputSettings analyticsOutputSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withAnalyticsOutputSettings(analyticsOutputSettings);
        return this;
    }

    public String analyticsWorkspaceId() {
        return this.innerProperties() == null ? null : this.innerProperties().analyticsWorkspaceId();
    }

    public ClusterInner withAnalyticsWorkspaceId(String analyticsWorkspaceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withAnalyticsWorkspaceId(analyticsWorkspaceId);
        return this;
    }

    public List<ClusterAvailableUpgradeVersion> availableUpgradeVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().availableUpgradeVersions();
    }

    public ClusterCapacity clusterCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterCapacity();
    }

    public ClusterConnectionStatus clusterConnectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterConnectionStatus();
    }

    public ExtendedLocation clusterExtendedLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterExtendedLocation();
    }

    public String clusterLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterLocation();
    }

    public ClusterInner withClusterLocation(String clusterLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withClusterLocation(clusterLocation);
        return this;
    }

    public ClusterManagerConnectionStatus clusterManagerConnectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterManagerConnectionStatus();
    }

    public String clusterManagerId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterManagerId();
    }

    public ServicePrincipalInformation clusterServicePrincipal() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterServicePrincipal();
    }

    public ClusterInner withClusterServicePrincipal(ServicePrincipalInformation clusterServicePrincipal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withClusterServicePrincipal(clusterServicePrincipal);
        return this;
    }

    public ClusterType clusterType() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterType();
    }

    public ClusterInner withClusterType(ClusterType clusterType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withClusterType(clusterType);
        return this;
    }

    public String clusterVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterVersion();
    }

    public ClusterInner withClusterVersion(String clusterVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withClusterVersion(clusterVersion);
        return this;
    }

    public CommandOutputSettings commandOutputSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().commandOutputSettings();
    }

    public ClusterInner withCommandOutputSettings(CommandOutputSettings commandOutputSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withCommandOutputSettings(commandOutputSettings);
        return this;
    }

    public ValidationThreshold computeDeploymentThreshold() {
        return this.innerProperties() == null ? null : this.innerProperties().computeDeploymentThreshold();
    }

    public ClusterInner withComputeDeploymentThreshold(ValidationThreshold computeDeploymentThreshold) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withComputeDeploymentThreshold(computeDeploymentThreshold);
        return this;
    }

    public List<RackDefinition> computeRackDefinitions() {
        return this.innerProperties() == null ? null : this.innerProperties().computeRackDefinitions();
    }

    public ClusterInner withComputeRackDefinitions(List<RackDefinition> computeRackDefinitions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withComputeRackDefinitions(computeRackDefinitions);
        return this;
    }

    public ClusterDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public ExtendedLocation hybridAksExtendedLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksExtendedLocation();
    }

    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().managedResourceGroupConfiguration();
    }

    public ClusterInner withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration managedResourceGroupConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withManagedResourceGroupConfiguration(managedResourceGroupConfiguration);
        return this;
    }

    public Long manualActionCount() {
        return this.innerProperties() == null ? null : this.innerProperties().manualActionCount();
    }

    public String networkFabricId() {
        return this.innerProperties() == null ? null : this.innerProperties().networkFabricId();
    }

    public ClusterInner withNetworkFabricId(String networkFabricId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withNetworkFabricId(networkFabricId);
        return this;
    }

    public ClusterProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public RuntimeProtectionConfiguration runtimeProtectionConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().runtimeProtectionConfiguration();
    }

    public ClusterInner withRuntimeProtectionConfiguration(RuntimeProtectionConfiguration runtimeProtectionConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withRuntimeProtectionConfiguration(runtimeProtectionConfiguration);
        return this;
    }

    public ClusterSecretArchive secretArchive() {
        return this.innerProperties() == null ? null : this.innerProperties().secretArchive();
    }

    public ClusterInner withSecretArchive(ClusterSecretArchive secretArchive) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withSecretArchive(secretArchive);
        return this;
    }

    public SecretArchiveSettings secretArchiveSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().secretArchiveSettings();
    }

    public ClusterInner withSecretArchiveSettings(SecretArchiveSettings secretArchiveSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withSecretArchiveSettings(secretArchiveSettings);
        return this;
    }

    public String supportExpiryDate() {
        return this.innerProperties() == null ? null : this.innerProperties().supportExpiryDate();
    }

    public ClusterUpdateStrategy updateStrategy() {
        return this.innerProperties() == null ? null : this.innerProperties().updateStrategy();
    }

    public ClusterInner withUpdateStrategy(ClusterUpdateStrategy updateStrategy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withUpdateStrategy(updateStrategy);
        return this;
    }

    public VulnerabilityScanningSettings vulnerabilityScanningSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().vulnerabilityScanningSettings();
    }

    public ClusterInner withVulnerabilityScanningSettings(VulnerabilityScanningSettings vulnerabilityScanningSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withVulnerabilityScanningSettings(vulnerabilityScanningSettings);
        return this;
    }

    public List<String> workloadResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadResourceIds();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model ClusterInner"));
        }
        this.extendedLocation().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ClusterInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ClusterInner fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterInner)((Object)jsonReader.readObject(reader -> {
            ClusterInner deserializedClusterInner = new ClusterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClusterInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClusterInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedClusterInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedClusterInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedClusterInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedClusterInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClusterInner.innerProperties = ClusterProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedClusterInner.etag = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedClusterInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedClusterInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterInner;
        }));
    }
}

