/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineProperties;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCordonStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePowerState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineProvisioningState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineReadyState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HardwareInventory;
import com.azure.resourcemanager.networkcloud.models.HardwareValidationStatus;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionStatus;
import com.azure.resourcemanager.networkcloud.models.SecretRotationStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class BareMetalMachineInner
extends Resource {
    private String etag;
    private ExtendedLocation extendedLocation;
    private BareMetalMachineProperties innerProperties = new BareMetalMachineProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachineInner.class);

    public String etag() {
        return this.etag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public BareMetalMachineInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private BareMetalMachineProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public BareMetalMachineInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BareMetalMachineInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<String> associatedResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedResourceIds();
    }

    public String bmcConnectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().bmcConnectionString();
    }

    public BareMetalMachineInner withBmcConnectionString(String bmcConnectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withBmcConnectionString(bmcConnectionString);
        return this;
    }

    public AdministrativeCredentials bmcCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().bmcCredentials();
    }

    public BareMetalMachineInner withBmcCredentials(AdministrativeCredentials bmcCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withBmcCredentials(bmcCredentials);
        return this;
    }

    public String bmcMacAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().bmcMacAddress();
    }

    public BareMetalMachineInner withBmcMacAddress(String bmcMacAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withBmcMacAddress(bmcMacAddress);
        return this;
    }

    public String bootMacAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().bootMacAddress();
    }

    public BareMetalMachineInner withBootMacAddress(String bootMacAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withBootMacAddress(bootMacAddress);
        return this;
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public BareMetalMachineCordonStatus cordonStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().cordonStatus();
    }

    public BareMetalMachineDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public HardwareInventory hardwareInventory() {
        return this.innerProperties() == null ? null : this.innerProperties().hardwareInventory();
    }

    public HardwareValidationStatus hardwareValidationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().hardwareValidationStatus();
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksClustersAssociatedIds();
    }

    public String kubernetesNodeName() {
        return this.innerProperties() == null ? null : this.innerProperties().kubernetesNodeName();
    }

    public String kubernetesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().kubernetesVersion();
    }

    public String machineClusterVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().machineClusterVersion();
    }

    public BareMetalMachineInner withMachineClusterVersion(String machineClusterVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withMachineClusterVersion(machineClusterVersion);
        return this;
    }

    public String machineDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().machineDetails();
    }

    public BareMetalMachineInner withMachineDetails(String machineDetails) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withMachineDetails(machineDetails);
        return this;
    }

    public String machineName() {
        return this.innerProperties() == null ? null : this.innerProperties().machineName();
    }

    public BareMetalMachineInner withMachineName(String machineName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withMachineName(machineName);
        return this;
    }

    public List<String> machineRoles() {
        return this.innerProperties() == null ? null : this.innerProperties().machineRoles();
    }

    public String machineSkuId() {
        return this.innerProperties() == null ? null : this.innerProperties().machineSkuId();
    }

    public BareMetalMachineInner withMachineSkuId(String machineSkuId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withMachineSkuId(machineSkuId);
        return this;
    }

    public String oamIpv4Address() {
        return this.innerProperties() == null ? null : this.innerProperties().oamIpv4Address();
    }

    public String oamIpv6Address() {
        return this.innerProperties() == null ? null : this.innerProperties().oamIpv6Address();
    }

    public String osImage() {
        return this.innerProperties() == null ? null : this.innerProperties().osImage();
    }

    public BareMetalMachinePowerState powerState() {
        return this.innerProperties() == null ? null : this.innerProperties().powerState();
    }

    public BareMetalMachineProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String rackId() {
        return this.innerProperties() == null ? null : this.innerProperties().rackId();
    }

    public BareMetalMachineInner withRackId(String rackId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withRackId(rackId);
        return this;
    }

    public long rackSlot() {
        return this.innerProperties() == null ? 0L : this.innerProperties().rackSlot();
    }

    public BareMetalMachineInner withRackSlot(long rackSlot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withRackSlot(rackSlot);
        return this;
    }

    public BareMetalMachineReadyState readyState() {
        return this.innerProperties() == null ? null : this.innerProperties().readyState();
    }

    public RuntimeProtectionStatus runtimeProtectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().runtimeProtectionStatus();
    }

    public List<SecretRotationStatus> secretRotationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().secretRotationStatus();
    }

    public String serialNumber() {
        return this.innerProperties() == null ? null : this.innerProperties().serialNumber();
    }

    public BareMetalMachineInner withSerialNumber(String serialNumber) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineProperties();
        }
        this.innerProperties().withSerialNumber(serialNumber);
        return this;
    }

    public String serviceTag() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceTag();
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachinesAssociatedIds();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model BareMetalMachineInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model BareMetalMachineInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineInner fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineInner)((Object)jsonReader.readObject(reader -> {
            BareMetalMachineInner deserializedBareMetalMachineInner = new BareMetalMachineInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBareMetalMachineInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBareMetalMachineInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBareMetalMachineInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedBareMetalMachineInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBareMetalMachineInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedBareMetalMachineInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBareMetalMachineInner.innerProperties = BareMetalMachineProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedBareMetalMachineInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBareMetalMachineInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineInner;
        }));
    }
}

