/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.RackInner;
import java.io.IOException;
import java.util.List;

public final class RackList
implements JsonSerializable<RackList> {
    private String nextLink;
    private List<RackInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public RackList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<RackInner> value() {
        return this.value;
    }

    public RackList withValue(List<RackInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RackList fromJson(JsonReader jsonReader) throws IOException {
        return (RackList)jsonReader.readObject(reader -> {
            RackList deserializedRackList = new RackList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedRackList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedRackList.value = value = reader.readArray(reader1 -> RackInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRackList;
        });
    }
}

