/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.L2NetworkInner;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.L2NetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.L2NetworkProvisioningState;
import java.util.List;
import java.util.Map;

public interface L2Network {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public List<String> associatedResourceIds();

    public String clusterId();

    public L2NetworkDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public List<String> hybridAksClustersAssociatedIds();

    public HybridAksPluginType hybridAksPluginType();

    public String interfaceName();

    public String l2IsolationDomainId();

    public L2NetworkProvisioningState provisioningState();

    public List<String> virtualMachinesAssociatedIds();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public L2NetworkInner innerModel();

    public Update update();

    public L2Network refresh();

    public L2Network refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public L2Network apply();

        public L2Network apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithInterfaceName {
            public WithCreate withInterfaceName(String var1);
        }

        public static interface WithHybridAksPluginType {
            public WithCreate withHybridAksPluginType(HybridAksPluginType var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithHybridAksPluginType,
        WithInterfaceName {
            public L2Network create();

            public L2Network create(Context var1);
        }

        public static interface WithL2IsolationDomainId {
            public WithCreate withL2IsolationDomainId(String var1);
        }

        public static interface WithExtendedLocation {
            public WithL2IsolationDomainId withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithL2IsolationDomainId,
    DefinitionStages.WithCreate {
    }
}

