/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterFeaturePatchProperties;
import com.azure.resourcemanager.networkcloud.models.StringKeyValuePair;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class KubernetesClusterFeaturePatchParameters
implements JsonSerializable<KubernetesClusterFeaturePatchParameters> {
    private KubernetesClusterFeaturePatchProperties innerProperties;
    private Map<String, String> tags;

    private KubernetesClusterFeaturePatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public KubernetesClusterFeaturePatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public List<StringKeyValuePair> options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public KubernetesClusterFeaturePatchParameters withOptions(List<StringKeyValuePair> options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterFeaturePatchProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterFeaturePatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterFeaturePatchParameters)jsonReader.readObject(reader -> {
            KubernetesClusterFeaturePatchParameters deserializedKubernetesClusterFeaturePatchParameters = new KubernetesClusterFeaturePatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedKubernetesClusterFeaturePatchParameters.innerProperties = KubernetesClusterFeaturePatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedKubernetesClusterFeaturePatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterFeaturePatchParameters;
        });
    }
}

