/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.BfdEnabled;
import java.io.IOException;
import java.util.List;

public final class IpAddressPool
implements JsonSerializable<IpAddressPool> {
    private List<String> addresses;
    private BfdEnabled autoAssign;
    private String name;
    private BfdEnabled onlyUseHostIps;
    private static final ClientLogger LOGGER = new ClientLogger(IpAddressPool.class);

    public List<String> addresses() {
        return this.addresses;
    }

    public IpAddressPool withAddresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public BfdEnabled autoAssign() {
        return this.autoAssign;
    }

    public IpAddressPool withAutoAssign(BfdEnabled autoAssign) {
        this.autoAssign = autoAssign;
        return this;
    }

    public String name() {
        return this.name;
    }

    public IpAddressPool withName(String name) {
        this.name = name;
        return this;
    }

    public BfdEnabled onlyUseHostIps() {
        return this.onlyUseHostIps;
    }

    public IpAddressPool withOnlyUseHostIps(BfdEnabled onlyUseHostIps) {
        this.onlyUseHostIps = onlyUseHostIps;
        return this;
    }

    public void validate() {
        if (this.addresses() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property addresses in model IpAddressPool"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model IpAddressPool"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("addresses", this.addresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("autoAssign", this.autoAssign == null ? null : this.autoAssign.toString());
        jsonWriter.writeStringField("onlyUseHostIps", this.onlyUseHostIps == null ? null : this.onlyUseHostIps.toString());
        return jsonWriter.writeEndObject();
    }

    public static IpAddressPool fromJson(JsonReader jsonReader) throws IOException {
        return (IpAddressPool)jsonReader.readObject(reader -> {
            IpAddressPool deserializedIpAddressPool = new IpAddressPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("addresses".equals(fieldName)) {
                    List addresses;
                    deserializedIpAddressPool.addresses = addresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIpAddressPool.name = reader.getString();
                    continue;
                }
                if ("autoAssign".equals(fieldName)) {
                    deserializedIpAddressPool.autoAssign = BfdEnabled.fromString(reader.getString());
                    continue;
                }
                if ("onlyUseHostIps".equals(fieldName)) {
                    deserializedIpAddressPool.onlyUseHostIps = BfdEnabled.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpAddressPool;
        });
    }
}

