/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.HardwareInventoryNetworkInterface;
import com.azure.resourcemanager.networkcloud.models.Nic;
import java.io.IOException;
import java.util.List;

public final class HardwareInventory
implements JsonSerializable<HardwareInventory> {
    private String additionalHostInformation;
    private List<HardwareInventoryNetworkInterface> interfaces;
    private List<Nic> nics;

    public String additionalHostInformation() {
        return this.additionalHostInformation;
    }

    public List<HardwareInventoryNetworkInterface> interfaces() {
        return this.interfaces;
    }

    public List<Nic> nics() {
        return this.nics;
    }

    public void validate() {
        if (this.interfaces() != null) {
            this.interfaces().forEach(e -> e.validate());
        }
        if (this.nics() != null) {
            this.nics().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static HardwareInventory fromJson(JsonReader jsonReader) throws IOException {
        return (HardwareInventory)jsonReader.readObject(reader -> {
            HardwareInventory deserializedHardwareInventory = new HardwareInventory();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("additionalHostInformation".equals(fieldName)) {
                    deserializedHardwareInventory.additionalHostInformation = reader.getString();
                    continue;
                }
                if ("interfaces".equals(fieldName)) {
                    List interfaces;
                    deserializedHardwareInventory.interfaces = interfaces = reader.readArray(reader1 -> HardwareInventoryNetworkInterface.fromJson(reader1));
                    continue;
                }
                if ("nics".equals(fieldName)) {
                    List nics;
                    deserializedHardwareInventory.nics = nics = reader.readArray(reader1 -> Nic.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHardwareInventory;
        });
    }
}

