/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ClusterSecretArchiveEnabled;
import java.io.IOException;

public final class ClusterSecretArchive
implements JsonSerializable<ClusterSecretArchive> {
    private String keyVaultId;
    private ClusterSecretArchiveEnabled useKeyVault;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterSecretArchive.class);

    public String keyVaultId() {
        return this.keyVaultId;
    }

    public ClusterSecretArchive withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    public ClusterSecretArchiveEnabled useKeyVault() {
        return this.useKeyVault;
    }

    public ClusterSecretArchive withUseKeyVault(ClusterSecretArchiveEnabled useKeyVault) {
        this.useKeyVault = useKeyVault;
        return this;
    }

    public void validate() {
        if (this.keyVaultId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyVaultId in model ClusterSecretArchive"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultId", this.keyVaultId);
        jsonWriter.writeStringField("useKeyVault", this.useKeyVault == null ? null : this.useKeyVault.toString());
        return jsonWriter.writeEndObject();
    }

    public static ClusterSecretArchive fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterSecretArchive)jsonReader.readObject(reader -> {
            ClusterSecretArchive deserializedClusterSecretArchive = new ClusterSecretArchive();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultId".equals(fieldName)) {
                    deserializedClusterSecretArchive.keyVaultId = reader.getString();
                    continue;
                }
                if ("useKeyVault".equals(fieldName)) {
                    deserializedClusterSecretArchive.useKeyVault = ClusterSecretArchiveEnabled.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterSecretArchive;
        });
    }
}

