/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterMetricsConfigurationInner;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import java.util.List;
import java.util.Map;

public interface ClusterMetricsConfiguration {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public long collectionInterval();

    public ClusterMetricsConfigurationDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public List<String> disabledMetrics();

    public List<String> enabledMetrics();

    public ClusterMetricsConfigurationProvisioningState provisioningState();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ClusterMetricsConfigurationInner innerModel();

    public Update update();

    public ClusterMetricsConfiguration refresh();

    public ClusterMetricsConfiguration refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithEnabledMetrics {
            public Update withEnabledMetrics(List<String> var1);
        }

        public static interface WithCollectionInterval {
            public Update withCollectionInterval(Long var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithCollectionInterval,
    UpdateStages.WithEnabledMetrics {
        public ClusterMetricsConfiguration apply();

        public ClusterMetricsConfiguration apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEnabledMetrics {
            public WithCreate withEnabledMetrics(List<String> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithEnabledMetrics {
            public ClusterMetricsConfiguration create();

            public ClusterMetricsConfiguration create(Context var1);
        }

        public static interface WithCollectionInterval {
            public WithCreate withCollectionInterval(long var1);
        }

        public static interface WithExtendedLocation {
            public WithCollectionInterval withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithParentResource {
            public WithExtendedLocation withExistingCluster(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithCollectionInterval,
    DefinitionStages.WithCreate {
    }
}

