/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineInner;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCordonParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCordonStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePowerOffParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePowerState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineProvisioningState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineReadyState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineReplaceParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunCommandParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunDataExtractsParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunReadCommandsParameters;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HardwareInventory;
import com.azure.resourcemanager.networkcloud.models.HardwareValidationStatus;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionStatus;
import com.azure.resourcemanager.networkcloud.models.SecretRotationStatus;
import java.util.List;
import java.util.Map;

public interface BareMetalMachine {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public List<String> associatedResourceIds();

    public String bmcConnectionString();

    public AdministrativeCredentials bmcCredentials();

    public String bmcMacAddress();

    public String bootMacAddress();

    public String clusterId();

    public BareMetalMachineCordonStatus cordonStatus();

    public BareMetalMachineDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public HardwareInventory hardwareInventory();

    public HardwareValidationStatus hardwareValidationStatus();

    public List<String> hybridAksClustersAssociatedIds();

    public String kubernetesNodeName();

    public String kubernetesVersion();

    public String machineClusterVersion();

    public String machineDetails();

    public String machineName();

    public List<String> machineRoles();

    public String machineSkuId();

    public String oamIpv4Address();

    public String oamIpv6Address();

    public String osImage();

    public BareMetalMachinePowerState powerState();

    public BareMetalMachineProvisioningState provisioningState();

    public String rackId();

    public long rackSlot();

    public BareMetalMachineReadyState readyState();

    public RuntimeProtectionStatus runtimeProtectionStatus();

    public List<SecretRotationStatus> secretRotationStatus();

    public String serialNumber();

    public String serviceTag();

    public List<String> virtualMachinesAssociatedIds();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public BareMetalMachineInner innerModel();

    public Update update();

    public BareMetalMachine refresh();

    public BareMetalMachine refresh(Context var1);

    public OperationStatusResult cordon();

    public OperationStatusResult cordon(BareMetalMachineCordonParameters var1, Context var2);

    public OperationStatusResult powerOff();

    public OperationStatusResult powerOff(BareMetalMachinePowerOffParameters var1, Context var2);

    public OperationStatusResult reimage();

    public OperationStatusResult reimage(Context var1);

    public OperationStatusResult replace();

    public OperationStatusResult replace(BareMetalMachineReplaceParameters var1, Context var2);

    public OperationStatusResult restart();

    public OperationStatusResult restart(Context var1);

    public OperationStatusResult runCommand(BareMetalMachineRunCommandParameters var1);

    public OperationStatusResult runCommand(BareMetalMachineRunCommandParameters var1, Context var2);

    public OperationStatusResult runDataExtracts(BareMetalMachineRunDataExtractsParameters var1);

    public OperationStatusResult runDataExtracts(BareMetalMachineRunDataExtractsParameters var1, Context var2);

    public OperationStatusResult runReadCommands(BareMetalMachineRunReadCommandsParameters var1);

    public OperationStatusResult runReadCommands(BareMetalMachineRunReadCommandsParameters var1, Context var2);

    public OperationStatusResult start();

    public OperationStatusResult start(Context var1);

    public OperationStatusResult uncordon();

    public OperationStatusResult uncordon(Context var1);

    public static interface UpdateStages {

        public static interface WithMachineDetails {
            public Update withMachineDetails(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithMachineDetails {
        public BareMetalMachine apply();

        public BareMetalMachine apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithMachineClusterVersion {
            public WithCreate withMachineClusterVersion(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithMachineClusterVersion {
            public BareMetalMachine create();

            public BareMetalMachine create(Context var1);
        }

        public static interface WithSerialNumber {
            public WithCreate withSerialNumber(String var1);
        }

        public static interface WithRackSlot {
            public WithSerialNumber withRackSlot(long var1);
        }

        public static interface WithRackId {
            public WithRackSlot withRackId(String var1);
        }

        public static interface WithMachineSkuId {
            public WithRackId withMachineSkuId(String var1);
        }

        public static interface WithMachineName {
            public WithMachineSkuId withMachineName(String var1);
        }

        public static interface WithMachineDetails {
            public WithMachineName withMachineDetails(String var1);
        }

        public static interface WithBootMacAddress {
            public WithMachineDetails withBootMacAddress(String var1);
        }

        public static interface WithBmcMacAddress {
            public WithBootMacAddress withBmcMacAddress(String var1);
        }

        public static interface WithBmcCredentials {
            public WithBmcMacAddress withBmcCredentials(AdministrativeCredentials var1);
        }

        public static interface WithBmcConnectionString {
            public WithBmcCredentials withBmcConnectionString(String var1);
        }

        public static interface WithExtendedLocation {
            public WithBmcConnectionString withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithBmcConnectionString,
    DefinitionStages.WithBmcCredentials,
    DefinitionStages.WithBmcMacAddress,
    DefinitionStages.WithBootMacAddress,
    DefinitionStages.WithMachineDetails,
    DefinitionStages.WithMachineName,
    DefinitionStages.WithMachineSkuId,
    DefinitionStages.WithRackId,
    DefinitionStages.WithRackSlot,
    DefinitionStages.WithSerialNumber,
    DefinitionStages.WithCreate {
    }
}

