/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AdministrativeCredentials
implements JsonSerializable<AdministrativeCredentials> {
    private String password;
    private String username;
    private static final ClientLogger LOGGER = new ClientLogger(AdministrativeCredentials.class);

    public String password() {
        return this.password;
    }

    public AdministrativeCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

    public String username() {
        return this.username;
    }

    public AdministrativeCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    public void validate() {
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model AdministrativeCredentials"));
        }
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model AdministrativeCredentials"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("username", this.username);
        return jsonWriter.writeEndObject();
    }

    public static AdministrativeCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (AdministrativeCredentials)jsonReader.readObject(reader -> {
            AdministrativeCredentials deserializedAdministrativeCredentials = new AdministrativeCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("password".equals(fieldName)) {
                    deserializedAdministrativeCredentials.password = reader.getString();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedAdministrativeCredentials.username = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdministrativeCredentials;
        });
    }
}

