/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.VolumeInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.Volume;
import com.azure.resourcemanager.networkcloud.models.VolumeDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.VolumePatchParameters;
import com.azure.resourcemanager.networkcloud.models.VolumeProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class VolumeImpl
implements Volume,
Volume.Definition,
Volume.Update {
    private VolumeInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String volumeName;
    private VolumePatchParameters updateVolumeUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<String> attachedTo() {
        List<String> inner = this.innerModel().attachedTo();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public VolumeDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public VolumeProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String serialNumber() {
        return this.innerModel().serialNumber();
    }

    @Override
    public long sizeMiB() {
        return this.innerModel().sizeMiB();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VolumeInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Volume create() {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().createOrUpdate(this.resourceGroupName, this.volumeName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Volume create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().createOrUpdate(this.resourceGroupName, this.volumeName, this.innerModel(), context);
        return this;
    }

    VolumeImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new VolumeInner();
        this.serviceManager = serviceManager;
        this.volumeName = name;
    }

    @Override
    public VolumeImpl update() {
        this.updateVolumeUpdateParameters = new VolumePatchParameters();
        return this;
    }

    @Override
    public Volume apply() {
        this.innerObject = (VolumeInner)((Object)this.serviceManager.serviceClient().getVolumes().updateWithResponse(this.resourceGroupName, this.volumeName, this.updateVolumeUpdateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Volume apply(Context context) {
        this.innerObject = (VolumeInner)((Object)this.serviceManager.serviceClient().getVolumes().updateWithResponse(this.resourceGroupName, this.volumeName, this.updateVolumeUpdateParameters, context).getValue());
        return this;
    }

    VolumeImpl(VolumeInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.volumeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "volumes");
    }

    @Override
    public Volume refresh() {
        this.innerObject = (VolumeInner)((Object)this.serviceManager.serviceClient().getVolumes().getByResourceGroupWithResponse(this.resourceGroupName, this.volumeName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Volume refresh(Context context) {
        this.innerObject = (VolumeInner)((Object)this.serviceManager.serviceClient().getVolumes().getByResourceGroupWithResponse(this.resourceGroupName, this.volumeName, context).getValue());
        return this;
    }

    @Override
    public VolumeImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public VolumeImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public VolumeImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public VolumeImpl withSizeMiB(long sizeMiB) {
        this.innerModel().withSizeMiB(sizeMiB);
        return this;
    }

    @Override
    public VolumeImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateVolumeUpdateParameters.withTags(tags);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

