/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ImageRepositoryCredentials;
import com.azure.resourcemanager.networkcloud.models.NetworkAttachment;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import com.azure.resourcemanager.networkcloud.models.StorageProfile;
import com.azure.resourcemanager.networkcloud.models.VirtualMachine;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineBootMethod;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineDeviceModelType;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineIsolateEmulatorThread;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePatchParameters;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePlacementHint;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePowerOffParameters;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePowerState;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineProvisioningState;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineVirtioInterfaceType;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class VirtualMachineImpl
implements VirtualMachine,
VirtualMachine.Definition,
VirtualMachine.Update {
    private VirtualMachineInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String virtualMachineName;
    private VirtualMachinePatchParameters updateVirtualMachineUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String adminUsername() {
        return this.innerModel().adminUsername();
    }

    @Override
    public String availabilityZone() {
        return this.innerModel().availabilityZone();
    }

    @Override
    public String bareMetalMachineId() {
        return this.innerModel().bareMetalMachineId();
    }

    @Override
    public VirtualMachineBootMethod bootMethod() {
        return this.innerModel().bootMethod();
    }

    @Override
    public NetworkAttachment cloudServicesNetworkAttachment() {
        return this.innerModel().cloudServicesNetworkAttachment();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public ExtendedLocation consoleExtendedLocation() {
        return this.innerModel().consoleExtendedLocation();
    }

    @Override
    public long cpuCores() {
        return this.innerModel().cpuCores();
    }

    @Override
    public VirtualMachineDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public VirtualMachineIsolateEmulatorThread isolateEmulatorThread() {
        return this.innerModel().isolateEmulatorThread();
    }

    @Override
    public long memorySizeGB() {
        return this.innerModel().memorySizeGB();
    }

    @Override
    public List<NetworkAttachment> networkAttachments() {
        List<NetworkAttachment> inner = this.innerModel().networkAttachments();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String networkData() {
        return this.innerModel().networkData();
    }

    @Override
    public List<VirtualMachinePlacementHint> placementHints() {
        List<VirtualMachinePlacementHint> inner = this.innerModel().placementHints();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public VirtualMachinePowerState powerState() {
        return this.innerModel().powerState();
    }

    @Override
    public VirtualMachineProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<SshPublicKey> sshPublicKeys() {
        List<SshPublicKey> inner = this.innerModel().sshPublicKeys();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public StorageProfile storageProfile() {
        return this.innerModel().storageProfile();
    }

    @Override
    public String userData() {
        return this.innerModel().userData();
    }

    @Override
    public VirtualMachineVirtioInterfaceType virtioInterface() {
        return this.innerModel().virtioInterface();
    }

    @Override
    public VirtualMachineDeviceModelType vmDeviceModel() {
        return this.innerModel().vmDeviceModel();
    }

    @Override
    public String vmImage() {
        return this.innerModel().vmImage();
    }

    @Override
    public ImageRepositoryCredentials vmImageRepositoryCredentials() {
        return this.innerModel().vmImageRepositoryCredentials();
    }

    @Override
    public List<String> volumes() {
        List<String> inner = this.innerModel().volumes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VirtualMachineInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualMachineImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public VirtualMachine create() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualMachines().createOrUpdate(this.resourceGroupName, this.virtualMachineName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public VirtualMachine create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualMachines().createOrUpdate(this.resourceGroupName, this.virtualMachineName, this.innerModel(), context);
        return this;
    }

    VirtualMachineImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new VirtualMachineInner();
        this.serviceManager = serviceManager;
        this.virtualMachineName = name;
    }

    @Override
    public VirtualMachineImpl update() {
        this.updateVirtualMachineUpdateParameters = new VirtualMachinePatchParameters();
        return this;
    }

    @Override
    public VirtualMachine apply() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualMachines().update(this.resourceGroupName, this.virtualMachineName, this.updateVirtualMachineUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public VirtualMachine apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualMachines().update(this.resourceGroupName, this.virtualMachineName, this.updateVirtualMachineUpdateParameters, context);
        return this;
    }

    VirtualMachineImpl(VirtualMachineInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.virtualMachineName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "virtualMachines");
    }

    @Override
    public VirtualMachine refresh() {
        this.innerObject = (VirtualMachineInner)((Object)this.serviceManager.serviceClient().getVirtualMachines().getByResourceGroupWithResponse(this.resourceGroupName, this.virtualMachineName, Context.NONE).getValue());
        return this;
    }

    @Override
    public VirtualMachine refresh(Context context) {
        this.innerObject = (VirtualMachineInner)((Object)this.serviceManager.serviceClient().getVirtualMachines().getByResourceGroupWithResponse(this.resourceGroupName, this.virtualMachineName, context).getValue());
        return this;
    }

    @Override
    public OperationStatusResult powerOff() {
        return this.serviceManager.virtualMachines().powerOff(this.resourceGroupName, this.virtualMachineName);
    }

    @Override
    public OperationStatusResult powerOff(VirtualMachinePowerOffParameters virtualMachinePowerOffParameters, Context context) {
        return this.serviceManager.virtualMachines().powerOff(this.resourceGroupName, this.virtualMachineName, virtualMachinePowerOffParameters, context);
    }

    @Override
    public OperationStatusResult reimage() {
        return this.serviceManager.virtualMachines().reimage(this.resourceGroupName, this.virtualMachineName);
    }

    @Override
    public OperationStatusResult reimage(Context context) {
        return this.serviceManager.virtualMachines().reimage(this.resourceGroupName, this.virtualMachineName, context);
    }

    @Override
    public OperationStatusResult restart() {
        return this.serviceManager.virtualMachines().restart(this.resourceGroupName, this.virtualMachineName);
    }

    @Override
    public OperationStatusResult restart(Context context) {
        return this.serviceManager.virtualMachines().restart(this.resourceGroupName, this.virtualMachineName, context);
    }

    @Override
    public OperationStatusResult start() {
        return this.serviceManager.virtualMachines().start(this.resourceGroupName, this.virtualMachineName);
    }

    @Override
    public OperationStatusResult start(Context context) {
        return this.serviceManager.virtualMachines().start(this.resourceGroupName, this.virtualMachineName, context);
    }

    @Override
    public VirtualMachineImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public VirtualMachineImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public VirtualMachineImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public VirtualMachineImpl withAdminUsername(String adminUsername) {
        this.innerModel().withAdminUsername(adminUsername);
        return this;
    }

    @Override
    public VirtualMachineImpl withCloudServicesNetworkAttachment(NetworkAttachment cloudServicesNetworkAttachment) {
        this.innerModel().withCloudServicesNetworkAttachment(cloudServicesNetworkAttachment);
        return this;
    }

    @Override
    public VirtualMachineImpl withCpuCores(long cpuCores) {
        this.innerModel().withCpuCores(cpuCores);
        return this;
    }

    @Override
    public VirtualMachineImpl withMemorySizeGB(long memorySizeGB) {
        this.innerModel().withMemorySizeGB(memorySizeGB);
        return this;
    }

    @Override
    public VirtualMachineImpl withStorageProfile(StorageProfile storageProfile) {
        this.innerModel().withStorageProfile(storageProfile);
        return this;
    }

    @Override
    public VirtualMachineImpl withVmImage(String vmImage) {
        this.innerModel().withVmImage(vmImage);
        return this;
    }

    @Override
    public VirtualMachineImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateVirtualMachineUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public VirtualMachineImpl withBootMethod(VirtualMachineBootMethod bootMethod) {
        this.innerModel().withBootMethod(bootMethod);
        return this;
    }

    @Override
    public VirtualMachineImpl withConsoleExtendedLocation(ExtendedLocation consoleExtendedLocation) {
        this.innerModel().withConsoleExtendedLocation(consoleExtendedLocation);
        return this;
    }

    @Override
    public VirtualMachineImpl withIsolateEmulatorThread(VirtualMachineIsolateEmulatorThread isolateEmulatorThread) {
        this.innerModel().withIsolateEmulatorThread(isolateEmulatorThread);
        return this;
    }

    @Override
    public VirtualMachineImpl withNetworkAttachments(List<NetworkAttachment> networkAttachments) {
        this.innerModel().withNetworkAttachments(networkAttachments);
        return this;
    }

    @Override
    public VirtualMachineImpl withNetworkData(String networkData) {
        this.innerModel().withNetworkData(networkData);
        return this;
    }

    @Override
    public VirtualMachineImpl withPlacementHints(List<VirtualMachinePlacementHint> placementHints) {
        this.innerModel().withPlacementHints(placementHints);
        return this;
    }

    @Override
    public VirtualMachineImpl withSshPublicKeys(List<SshPublicKey> sshPublicKeys) {
        this.innerModel().withSshPublicKeys(sshPublicKeys);
        return this;
    }

    @Override
    public VirtualMachineImpl withUserData(String userData) {
        this.innerModel().withUserData(userData);
        return this;
    }

    @Override
    public VirtualMachineImpl withVirtioInterface(VirtualMachineVirtioInterfaceType virtioInterface) {
        this.innerModel().withVirtioInterface(virtioInterface);
        return this;
    }

    @Override
    public VirtualMachineImpl withVmDeviceModel(VirtualMachineDeviceModelType vmDeviceModel) {
        this.innerModel().withVmDeviceModel(vmDeviceModel);
        return this;
    }

    @Override
    public VirtualMachineImpl withVmImageRepositoryCredentials(ImageRepositoryCredentials vmImageRepositoryCredentials) {
        if (this.isInCreateMode()) {
            this.innerModel().withVmImageRepositoryCredentials(vmImageRepositoryCredentials);
            return this;
        }
        this.updateVirtualMachineUpdateParameters.withVmImageRepositoryCredentials(vmImageRepositoryCredentials);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

