/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.TrunkedNetworksClient;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.fluent.models.TrunkedNetworkInner;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.implementation.TrunkedNetworkImpl;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetwork;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworks;

public final class TrunkedNetworksImpl
implements TrunkedNetworks {
    private static final ClientLogger LOGGER = new ClientLogger(TrunkedNetworksImpl.class);
    private final TrunkedNetworksClient innerClient;
    private final NetworkCloudManager serviceManager;

    public TrunkedNetworksImpl(TrunkedNetworksClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TrunkedNetwork> list() {
        PagedIterable<TrunkedNetworkInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TrunkedNetworkImpl((TrunkedNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TrunkedNetwork> list(Context context) {
        PagedIterable<TrunkedNetworkInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TrunkedNetworkImpl((TrunkedNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TrunkedNetwork> listByResourceGroup(String resourceGroupName) {
        PagedIterable<TrunkedNetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TrunkedNetworkImpl((TrunkedNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TrunkedNetwork> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<TrunkedNetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TrunkedNetworkImpl((TrunkedNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TrunkedNetwork> getByResourceGroupWithResponse(String resourceGroupName, String trunkedNetworkName, Context context) {
        Response<TrunkedNetworkInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, trunkedNetworkName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TrunkedNetworkImpl((TrunkedNetworkInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TrunkedNetwork getByResourceGroup(String resourceGroupName, String trunkedNetworkName) {
        TrunkedNetworkInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, trunkedNetworkName);
        if (inner != null) {
            return new TrunkedNetworkImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String trunkedNetworkName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, trunkedNetworkName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String trunkedNetworkName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, trunkedNetworkName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public TrunkedNetwork getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String trunkedNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "trunkedNetworks");
        if (trunkedNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'trunkedNetworks'.", id)));
        }
        return (TrunkedNetwork)this.getByResourceGroupWithResponse(resourceGroupName, trunkedNetworkName, Context.NONE).getValue();
    }

    @Override
    public Response<TrunkedNetwork> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String trunkedNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "trunkedNetworks");
        if (trunkedNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'trunkedNetworks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, trunkedNetworkName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String trunkedNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "trunkedNetworks");
        if (trunkedNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'trunkedNetworks'.", id)));
        }
        return this.delete(resourceGroupName, trunkedNetworkName, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String trunkedNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "trunkedNetworks");
        if (trunkedNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'trunkedNetworks'.", id)));
        }
        return this.delete(resourceGroupName, trunkedNetworkName, context);
    }

    private TrunkedNetworksClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public TrunkedNetworkImpl define(String name) {
        return new TrunkedNetworkImpl(name, this.manager());
    }
}

