/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.RackInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.Rack;
import com.azure.resourcemanager.networkcloud.models.RackDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.RackPatchParameters;
import com.azure.resourcemanager.networkcloud.models.RackProvisioningState;
import java.util.Collections;
import java.util.Map;

public final class RackImpl
implements Rack,
Rack.Definition,
Rack.Update {
    private RackInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String rackName;
    private RackPatchParameters updateRackUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String availabilityZone() {
        return this.innerModel().availabilityZone();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public RackDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public RackProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String rackLocation() {
        return this.innerModel().rackLocation();
    }

    @Override
    public String rackSerialNumber() {
        return this.innerModel().rackSerialNumber();
    }

    @Override
    public String rackSkuId() {
        return this.innerModel().rackSkuId();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public RackInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public RackImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Rack create() {
        this.innerObject = this.serviceManager.serviceClient().getRacks().createOrUpdate(this.resourceGroupName, this.rackName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Rack create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getRacks().createOrUpdate(this.resourceGroupName, this.rackName, this.innerModel(), context);
        return this;
    }

    RackImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new RackInner();
        this.serviceManager = serviceManager;
        this.rackName = name;
    }

    @Override
    public RackImpl update() {
        this.updateRackUpdateParameters = new RackPatchParameters();
        return this;
    }

    @Override
    public Rack apply() {
        this.innerObject = this.serviceManager.serviceClient().getRacks().update(this.resourceGroupName, this.rackName, this.updateRackUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public Rack apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getRacks().update(this.resourceGroupName, this.rackName, this.updateRackUpdateParameters, context);
        return this;
    }

    RackImpl(RackInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.rackName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "racks");
    }

    @Override
    public Rack refresh() {
        this.innerObject = (RackInner)((Object)this.serviceManager.serviceClient().getRacks().getByResourceGroupWithResponse(this.resourceGroupName, this.rackName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Rack refresh(Context context) {
        this.innerObject = (RackInner)((Object)this.serviceManager.serviceClient().getRacks().getByResourceGroupWithResponse(this.resourceGroupName, this.rackName, context).getValue());
        return this;
    }

    @Override
    public RackImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public RackImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public RackImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public RackImpl withAvailabilityZone(String availabilityZone) {
        this.innerModel().withAvailabilityZone(availabilityZone);
        return this;
    }

    @Override
    public RackImpl withRackLocation(String rackLocation) {
        if (this.isInCreateMode()) {
            this.innerModel().withRackLocation(rackLocation);
            return this;
        }
        this.updateRackUpdateParameters.withRackLocation(rackLocation);
        return this;
    }

    @Override
    public RackImpl withRackSerialNumber(String rackSerialNumber) {
        if (this.isInCreateMode()) {
            this.innerModel().withRackSerialNumber(rackSerialNumber);
            return this;
        }
        this.updateRackUpdateParameters.withRackSerialNumber(rackSerialNumber);
        return this;
    }

    @Override
    public RackImpl withRackSkuId(String rackSkuId) {
        this.innerModel().withRackSkuId(rackSkuId);
        return this;
    }

    @Override
    public RackImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateRackUpdateParameters.withTags(tags);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

