/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.AgentPoolsClient;
import com.azure.resourcemanager.networkcloud.fluent.models.AgentPoolInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.AgentPoolList;
import com.azure.resourcemanager.networkcloud.models.AgentPoolPatchParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AgentPoolsClientImpl
implements AgentPoolsClient {
    private final AgentPoolsService service;
    private final NetworkCloudImpl client;

    AgentPoolsClientImpl(NetworkCloudImpl client) {
        this.service = (AgentPoolsService)RestProxy.create(AgentPoolsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listByKubernetesClusterSinglePageAsync(String resourceGroupName, String kubernetesClusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByKubernetesCluster(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listByKubernetesClusterSinglePageAsync(String resourceGroupName, String kubernetesClusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByKubernetesCluster(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AgentPoolInner> listByKubernetesClusterAsync(String resourceGroupName, String kubernetesClusterName) {
        return new PagedFlux(() -> this.listByKubernetesClusterSinglePageAsync(resourceGroupName, kubernetesClusterName), nextLink -> this.listByKubernetesClusterNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AgentPoolInner> listByKubernetesClusterAsync(String resourceGroupName, String kubernetesClusterName, Context context) {
        return new PagedFlux(() -> this.listByKubernetesClusterSinglePageAsync(resourceGroupName, kubernetesClusterName, context), nextLink -> this.listByKubernetesClusterNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AgentPoolInner> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName) {
        return new PagedIterable(this.listByKubernetesClusterAsync(resourceGroupName, kubernetesClusterName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AgentPoolInner> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName, Context context) {
        return new PagedIterable(this.listByKubernetesClusterAsync(resourceGroupName, kubernetesClusterName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AgentPoolInner>> getWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AgentPoolInner>> getWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> getAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        return this.getWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AgentPoolInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AgentPoolInner> getWithResponse(String resourceGroupName, String kubernetesClusterName, String agentPoolName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner get(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        return (AgentPoolInner)((Object)this.getWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolParameters is required and cannot be null."));
        }
        agentPoolParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolParameters is required and cannot be null."));
        }
        agentPoolParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner createOrUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters) {
        return (AgentPoolInner)((Object)this.createOrUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner createOrUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, Context context) {
        return (AgentPoolInner)((Object)this.createOrUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, agentPoolName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName, String agentPoolName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, agentPoolName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, agentPoolName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, agentPoolName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, kubernetesClusterName, agentPoolName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String kubernetesClusterName, String agentPoolName, Context context) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, kubernetesClusterName, agentPoolName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolPatchParameters agentPoolUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolUpdateParameters != null) {
            agentPoolUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolPatchParameters agentPoolUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolUpdateParameters != null) {
            agentPoolUpdateParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolPatchParameters agentPoolUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        AgentPoolPatchParameters agentPoolUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolPatchParameters agentPoolUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        AgentPoolPatchParameters agentPoolUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolPatchParameters agentPoolUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> updateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolPatchParameters agentPoolUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> updateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        AgentPoolPatchParameters agentPoolUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> updateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolPatchParameters agentPoolUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner update(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        AgentPoolPatchParameters agentPoolUpdateParameters = null;
        return (AgentPoolInner)((Object)this.updateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner update(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolPatchParameters agentPoolUpdateParameters, Context context) {
        return (AgentPoolInner)((Object)this.updateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listByKubernetesClusterNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByKubernetesClusterNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listByKubernetesClusterNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByKubernetesClusterNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudAgentPoo")
    public static interface AgentPoolsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AgentPoolList>> listByKubernetesCluster(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AgentPoolInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @BodyParam(value="application/json") AgentPoolInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @BodyParam(value="application/json") AgentPoolPatchParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AgentPoolList>> listByKubernetesClusterNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

